% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataContainer

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{DataContainer}
\alias{DataContainer}
\title{DataContainer}
\description{A class for storing a matrix and relevant metaData.  This class is the starting point for all of the Data oriented classes.  However, its not really useful on its own, and serves mostly as a placeholder generic class in case we want to implement a drastically different type of model. This class should only need to be extended in the case where we implement something outside the scope of MatrixDataContainer}
\seealso{
Is inherited by : \code{\link{MatrixData}}}
\examples{
SampleDataContainer <- R6Class(
  inherit= DataContainer,
  public = list(
    initialize = function(...)\{
      self$metaData = list(...)
    \}
  )
)
data <- SampleDataContainer$new(letters[1:10],1:10)
data
data$metaData
}
\section{Fields}{
\describe{
\item{metaData}{Any data not part of the main data structure.}
}}
\section{Methods}{
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{initialize(...)}{
This function \bold{should} be extended. Create a new instance of this class.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{This function should take in any arguments just in case.}
}}}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
