% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimpleForecast

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{SimpleForecast}
\alias{SimpleForecast}
\title{SimpleForecast}
\description{A basic concrete SimulatedForecast class.}
\seealso{
Inherits from : \code{\link{Forecast}}

}
\examples{
data = IncidenceMatrix$new(matrix(1:9,3,3))
forecast = SimpleForecast$new(data,forecastTimes=c(FALSE,FALSE,TRUE))
forecast
forecast$forecastTimes
forecast$forecastMadeTime
forecast$data$mat
forecast$nsim
forecast$mean()$mat
forecast$median()$mat

}
\section{Fields}{
\describe{
\item{data}{ The data used to create the forecast.}
\item{forecastMadeTime}{When the forecast was created.}
\item{forecastTimes}{The times the forecast is about.}
\item{model}{The model used to create the forecast.}
}}
\section{Methods}{
\methodname{binDist(cutoffs)}{
This throws an error.  This method is not meaningful for this data.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{cutoffs}{A numeric vector with elements to use as the dividing values for the bins.}
}}}}
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{initialize(data,forecastTimes)}{
Create a new SimpleForecast.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to initialize with}
\methoditem{forecastTimes}{Boolean representing which times are forecasted, and which times are not.}
}}}}
\methodname{mean()}{
This method returns the data.  It is included for compliance.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}
\item{Value}{a MatrixData.}
}}
\methodname{median()}{
This method returns the data.  It is included for compliance.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}
\item{Value}{a MatrixData.}
}}
\methodname{quantile(alphas)}{
This throws an error.  This method is not meaningful for this data.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{alphas}{A numeric vector with elements between \code{0} and \code{1} of percentiles to find cutoffs for.}
}}
\item{Value}{an ArrayData.}
}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
