% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetpc.R
\name{FrechTree}
\alias{FrechTree}
\title{FrechTree}
\usage{
FrechTree(X, Y, id, time, select = "CV", ...)
}
\arguments{
\item{X}{[matrix]: a data frame or a matrix of trajectories predictors. Each colunm codes for a trajectory predictor.}

\item{Y}{[vector]: a vector containing the output trajectories (same length as \code{nrow(X)}).}

\item{id}{[vector (factor)]: identifier, one for each trajectory to attribute each measurement of \code{X} and \code{Y} to one of the trajectories (same length as \code{Y}).}

\item{time}{[vector]: time measurements for the observations of both \code{X} and \code{Y} (same length as \code{Y}).}

\item{select}{[character]: a character string indicating which criteria to select the optimal pruned sub-tree, either "CV" for cross validation on the prediction error or "Hubert" for the Hubert's statistics. Default is "CV".}

\item{...}{: optional parameters to be passed to the low level function}
}
\value{
a Frechet treee which is a list of the following elements :\itemize{
\item \code{feuilles}: a vector indicating in which leaf is each measurement.
\item \code{V_split}: a matrix of two columns that describes the structure of the tree. Each row codes for a split, the first column indicates the node and the second column gives the associated splitting variable.
\item \code{Y_curves}: a list of the predicted trajectories (Frechet mean) for each leaf of the optimal Frechet tree.
\item \code{hist_nodes}: a list of the representative trajectories for each node according to the associated splitting variable.
}
}
\description{
This function runs Frechet tree for longitudinal data using some shape respecting distance and mean.
}
\examples{
\dontrun{
set.seed(10)
data <- DataGenCurves(40)
Ft <- FrechTree(data$X,data$Y, data$id,data$time,select = "Hubert", toPlot="none")
}
}
