% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-FuzzyPairwiseComparisonMatrix.R
\docType{methods}
\name{fuzzyPairwiseComparisonMatrix}
\alias{fuzzyPairwiseComparisonMatrix}
\alias{fuzzyPairwiseComparisonMatrix,PairwiseComparisonMatrix,fuzzyScale-method}
\alias{fuzzyPairwiseComparisonMatrix,PairwiseComparisonMatrix-method}
\title{Function that creates Fuzzy Pairwise Comparions Matrix}
\usage{
fuzzyPairwiseComparisonMatrix(pairwiseComparisonMatrix, fuzzyScale)


  \S4method{fuzzyPairwiseComparisonMatrix}{PairwiseComparisonMatrix}(pairwiseComparisonMatrix,
  fuzzyScale = as.double(c(1/2, 1, 2, 1, 2, 3, 2, 3, 4, 3, 4, 5, 4, 5, 6, 5,
  6, 7, 6, 7, 8, 7, 8, 9, 8, 9, 9)))
}
\arguments{
\item{pairwiseComparisonMatrix}{\linkS4class{PairwiseComparisonMatrix}.}

\item{fuzzyScale}{A numeric vector that definies fuzzy scale. Default scale is described in details.}
}
\value{
Object of class \linkS4class{FuzzyPairwiseComparisonMatrix}
}
\description{
This methods construct object \linkS4class{FuzzyPairwiseComparisonMatrix} based on provided
\linkS4class{PairwiseComparisonMatrix} and an optional fuzzy scale.
}
\details{
Parameter fuzzyScale is expected as a vector containing n*3 values that represent triangular fuzzy
numbers used as fuzzy intensity of importance (only the values equal or higher than 1, inverse values
are calculated automatically). The values need to be ordered by fuzzy values. Default value of this
parameter is \code{as.double(c(1/2,1,2,1,2,3,2,3,4,3,4,5,4,5,6,5,6,7,6,7,8,7,8,9,8,9,9))}. Another
possibility is eg. \code{as.double(c(1/3,1,3,1,3,5,3,5,7,5,7,9,7,9,9))}
}

