% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GauNBFuzzyParam.R
\name{GauNBFuzzyParam}
\alias{GauNBFuzzyParam}
\title{Fuzzy Gaussian Naive Bayes Classifier with Fuzzy parameters}
\usage{
GauNBFuzzyParam(train, cl, alphacut = 1e-04, metd = 2, cores = 2)
}
\arguments{
\item{train}{matrix or data frame of training set cases.}

\item{cl}{factor of true classifications of training set}

\item{alphacut}{value of the alpha-cut parameter, this value is between 0 and 1.}

\item{metd}{Method of transforming the triangle into scalar, It is the type of data entry for the test sample, use metd 1 if you want to use the Yager technique, metd 2 if you want to use the Q technique of the uniformity test (article: Directional Statistics and Shape analysis), and metd 3 if you want to use the Thorani technique}

\item{cores}{how many cores of the computer do you want to use (default = 2)}
}
\value{
A vector of classifications
}
\description{
\code{GauNBFuzzyParam} Fuzzy Gaussian Naive Bayes Classifier with Fuzzy parameters
}
\examples{

set.seed(1) # determining a seed
data(iris)

# Splitting into Training and Testing
split <- caTools::sample.split(t(iris[, 1]), SplitRatio = 0.7)
Train <- subset(iris, split == "TRUE")
Test <- subset(iris, split == "FALSE")
# ----------------
# matrix or data frame of test set cases.
# A vector will be interpreted as a row vector for a single case.
test <- Test[, -5]
fit_FGNB <- GauNBFuzzyParam(
  train = Train[, -5],
  cl = Train[, 5], metd = 1, cores = 2
)

pred_FGNB <- predict(fit_FGNB, test)

head(pred_FGNB)
head(Test[, 5])
}
\references{
\insertRef{moraes2021new}{FuzzyClass}
}
