% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpNBFuzzyParam.R
\name{ExpNBFuzzyParam}
\alias{ExpNBFuzzyParam}
\title{Fuzzy Exponential Naive Bayes Classifier with Fuzzy parameters}
\usage{
ExpNBFuzzyParam(
  train,
  cl,
  alphacut = 1e-04,
  metd = 2,
  alp = c(0.35, 0.7, 0.86),
  w = c(0.1, 0.3, 0.6),
  cores = 2
)
}
\arguments{
\item{train}{matrix or data frame of training set cases}

\item{cl}{factor of true classifications of training set}

\item{alphacut}{value of the alpha-cut parameter, this value is between 0 and 1.}

\item{metd}{Method of transforming the triangle into scalar, It is the type of data entry for the test sample, use metd 1 if you want to use the Yager technique, metd 2 if you want to use the Q technique of the uniformity test (article: Directional Statistics and Shape analysis), and metd 3 if you want to use the Thorani technique}

\item{alp}{When metd for 4, it is necessary to have alp which are alpha-cut defined}

\item{w}{When metd for 4, it is necessary to have w which are alpha-cut weights defined}

\item{cores}{how many cores of the computer do you want to use (default = 2)}
}
\value{
A vector of classifications
}
\description{
\code{ExpNBFuzzyParam} Fuzzy Exponential Naive Bayes Classifier with Fuzzy parameters
}
\examples{

set.seed(1) # determining a seed
data(VirtualRealityData)

# Splitting into Training and Testing
split <- caTools::sample.split(t(VirtualRealityData[, 1]), SplitRatio = 0.7)
Train <- subset(VirtualRealityData, split == "TRUE")
Test <- subset(VirtualRealityData, split == "FALSE")

# ----------------
# matrix or data frame of test set cases.
# A vector will be interpreted as a row vector for a single case.
test <- Test[, -4]
fit_FENB <- ExpNBFuzzyParam(
  train = Train[, -4],
  cl = Train[, 4], metd = 1, cores = 2
)

pred_FENB <- predict(fit_FENB, test)

head(pred_FENB)
head(Test[, 4])
}
\references{
\insertRef{rodrigues2016new}{FuzzyClass}
}
