\name{DiscontinuousFuzzyNumber}
\alias{DiscontinuousFuzzyNumber}
\title{Creates a Fuzzy Number with Possibly Discontinuous Side Functions or Alpha-Cut Bounds}
\usage{
  DiscontinuousFuzzyNumber(a1, a2, a3, a4,
    lower = function(a) rep(NA_real_, length(a)),
    upper = function(a) rep(NA_real_, length(a)),
    left = function(x) rep(NA_real_, length(x)),
    right = function(x) rep(NA_real_, length(x)),
    discontinuities.left = numeric(0),
    discontinuities.right = numeric(0),
    discontinuities.lower = numeric(0),
    discontinuities.upper = numeric(0))
}
\arguments{
  \item{a1}{a number specyfing left bound of the support}

  \item{a2}{a number specyfing left bound of the core}

  \item{a3}{a number specyfing right bound of the core}

  \item{a4}{a number specyfing right bound of the support}

  \item{lower}{lower alpha-cut bound generator; a
  nondecreasing function [0,1]->[0,1] or returning
  NA_real_}

  \item{upper}{upper alpha-cut bound generator; a
  nonincreasing function [0,1]->[1,0] or returning
  NA_real_}

  \item{left}{lower side function generator; a
  nondecreasing function [0,1]->[0,1] or returning
  NA_real_}

  \item{right}{upper side function generator; a
  nonincreasing function [0,1]->[1,0] or returning
  NA_real_}

  \item{discontinuities.left}{nondecreasingly sorted
  numeric vector with elements in (0,1), possibly of length
  0}

  \item{discontinuities.right}{nondecreasingly sorted
  numeric vector with elements in (0,1), possibly of length
  0}

  \item{discontinuities.lower}{nondecreasingly sorted
  numeric vector with elements in (0,1), possibly of length
  0}

  \item{discontinuities.upper}{nondecreasingly sorted
  numeric vector with elements in (0,1), possibly of length
  0}
}
\value{
  Object of class
  \code{\linkS4class{DiscontinuousFuzzyNumber}}
}
\description{
  For convenience, objects of class
  \code{\linkS4class{DiscontinuousFuzzyNumber}} may be
  created with this function.
}
\seealso{
  Other DiscontinuousFuzzyNumber-method:
  \code{\link{DiscontinuousFuzzyNumber-class}},
  \code{\link{distance}}, \code{\link{integrateAlpha}},
  \code{\link{plot}}
}

