% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-alphacut.R
\docType{methods}
\name{alphacut}
\alias{alphacut}
\alias{alphacut,FuzzyNumber,numeric-method}
\title{Compute Alpha-Cuts}
\usage{
\S4method{alphacut}{FuzzyNumber,numeric}(object, alpha)
}
\arguments{
\item{object}{a fuzzy number}

\item{alpha}{numeric vector with elements in [0,1]}
}
\value{
Returns a matrix with two columns (left and right alha cut bounds).
if some elements in \code{alpha} are not in [0,1], then \code{NA}
is set.
}
\description{
If \eqn{A} is a fuzzy number, then its \eqn{\alpha}-cuts are
always in form of intervals.
Moreover, the \eqn{\alpha}-cuts form a nonincreasing
chain w.r.t. \eqn{alpha}.
}
\examples{
A <- TrapezoidalFuzzyNumber(1, 2, 3, 4)
alphacut(A, c(-1, 0.4, 0.2))
}
\seealso{
Other FuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{FuzzyNumber-class}},
  \code{\link{FuzzyNumber}}, \code{\link{alphaInterval}},
  \code{\link{ambiguity}}, \code{\link{as.FuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}, \code{\link{core}},
  \code{\link{distance}}, \code{\link{evaluate}},
  \code{\link{expectedInterval}},
  \code{\link{expectedValue}},
  \code{\link{integrateAlpha}},
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{plot}}, \code{\link{show}},
  \code{\link{supp}},
  \code{\link{trapezoidalApproximation}},
  \code{\link{value}}, \code{\link{weightedExpectedValue}},
  \code{\link{width}}

Other alpha_cuts: \code{\link{core}}, \code{\link{supp}}
}
\concept{FuzzyNumber-method}
\concept{alpha_cuts}
