% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_weight.R
\name{fs_weight}
\alias{fs_weight}
\title{Fuzzy supplementary poverty estimation (Steps 4 and 5)}
\usage{
fs_weight(dimensions, step2, rho = NULL)
}
\arguments{
\item{dimensions}{A numeric vector (of length  \code{ncol(data)}) of assignments of items in data to dimensions}

\item{step2}{The data frame resulting from step2}

\item{rho}{Optional critical value to be used for calculation of weights in the Kendall correlation matrix. If NULL rho is set equal to the point of largest gap between the ordered set of correlation values encountered (see Betti and Verma, 2008)}
}
\value{
An object of class FuzzySupplementary with calculated weights and deprivation scores in each dimension identified.
}
\description{
Step 4 and Step 5. Calculates the weights of dimensions discovered after Dimension analysis.
}
\details{
This function calculates the two set of weights w_a and w_b (see References)
}
\examples{
#This example is based on the dataset eusilc included in the package
#The step 2-3 are the following (step 1 is the eusilc dataset)
#For more on each step see the ad hoc function included in the package

#Step 2

step2 = fs_transform(eusilc[,4:23], weight = eusilc$DB090, ID = eusilc$ID)

#Step 3 is the definition of the dimension.
#For more about the step see Betti et al. (2018)

dimensions = c(1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5)

#Step 4-5 finding weights

steps4_5 = fs_weight(dimensions, step2 = step2, rho = NULL)

}
\references{
Betti, G., & Verma, V. (2008). Fuzzy measures of the incidence of relative poverty and deprivation: a multi-dimensional perspective. Statistical Methods and Applications, 17, 225-250.

Betti, G., Gagliardi, F., & Verma, V. (2018). Simplified Jackknife variance estimates for fuzzy measures of multidimensional poverty. International Statistical Review, 86(1), 68-86.
}
