% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq_predicate.R
\name{eq_predicate}
\alias{eq_predicate}
\title{Calculation of Equivalized Poverty Predicate}
\usage{
eq_predicate(
  predicate,
  ncomp,
  age = NULL,
  scale.eq = "modifiedOECD",
  newscale,
  data = NULL
)
}
\arguments{
\item{predicate}{A numeric vector  (or the variable name) representing the poverty predicate (i.e. income or expenditure)}

\item{ncomp}{A numerical vector (or the variable name) of the total number of components for the j-th family.}

\item{age}{A numerical vector (or the variable name) of the number of components for the j-th family less than 16 years-old}

\item{scale.eq}{The equivalence scale. Options are: "carbonaro", "n.par" (non parametric), "OECD7050", "modifiedOECD" (Default) or "new"}

\item{newscale}{a data.frame with two columns: "ncomp"  defining the number of components and  "s.eq" that define the corresponding}

\item{data}{An optional data frame containing the variables to be used}
}
\value{
A data.frame containing the equivalised predicate variable.
}
\description{
This function takes as input a numeric vector representing a predicate variable and turns it into its equivalised version
using different equivalence scales.
}
\examples{


#Using OECD scale

eq_predicate(predicate = "HY022", ncomp = "ncomp", age = "age16",
             scale.eq = "OECD7050", data = eusilc) #OECD7050

eq_predicate(predicate = "HY022", ncomp = "ncomp", age = "age16",
             scale.eq = "modifiedOECD", data = eusilc) #modifiedOECD

#Define a new scale

newscal <- data.frame("ncomp" = c(1:7), "s.eq" = runif(7,1,10) ) # new


eq_predicate(predicate = "HY022", ncomp = "ncomp", scale.eq = "new",
             newscale = newscal, data = eusilc)

}
\references{
Bernini, C., Emili, S., & Ferrante, M. R. (2024). Regional disparities in the sensitivity of wellbeing to poverty measures. In Spatial Inequalities and Wellbeing (pp. 136-157). Edward Elgar Publishing.

Betti, G. (1999). Nonparametric equivalence scales with application to Poland. Statistics Research Report.

Chanfreau, J., & Burchardt, T. (2008). Equivalence scales: rationales, uses and assumptions. Edinburgh: Scottish Government.
}
