% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BertoluzzaDistance.R
\name{BertoluzzaDistance}
\alias{BertoluzzaDistance}
\title{Calculate Bertoluzza's (mid/spread) distance for triangular and trapezoidal fuzzy numbers}
\usage{
BertoluzzaDistance(fuzzyNumber1, fuzzyNumber2, theta = 1/3, increases = FALSE)
}
\arguments{
\item{fuzzyNumber1}{The first triangular or trapezoidal fuzzy number.
More than one value can be given in the form of matrix.}

\item{fuzzyNumber2}{The second triangular or trapezoidal fuzzy number.
More than one value can be given in the form of matrix.}

\item{theta}{The weighting parameter for the mid/spread distance.}

\item{increases}{If \code{TRUE} is used, then the fuzzy numbers should be given in the form:
left increment of the support, left end of the core, right end of the core,
right increment of the support. Otherwise, the default value \code{FALSE} is used and the fuzzy numbers should be given in the form:
left end of the support, left end of the core, right end of the core,
right end of the support.}
}
\value{
This function returns vector of doubles related to the calculated distances.
}
\description{
\code{BertoluzzaDistance} returns the Bertoulzza et al.'s (aka mid/spread) distance with the given weight \code{theta}
between two triangular or trapezoidal fuzzy numbers.
}
\details{
The input fuzzy values should be triangular or trapezoidal fuzzy numbers, given as a single vector or a whole matrix.
In each row, there should be a single fuzzy number in one of the forms:
\enumerate{
\item left end of the support, left end of the core, right end of the core, right end of the support, or
\item left increment of the support, left end of the core, right end of the core, right increment of the support.
}
In this second case, the parameter \code{increases=TRUE} has to be used.

The procedure calculates the mid/spread distance between two fuzzy values based on the weight \code{theta},
usually we have \code{theta = 1/3} or \code{theta = 1}.
The output is given as vector of distances.
}
\examples{

# prepare some fuzzy numbers (first type of the initial sample)

fuzzyValues <- matrix(c(0.25,0.5,1,1.25,0.75,1,1.5,2.2,-1,0,0,2),ncol = 4,byrow = TRUE)

# calculate the mid/spread distance between the first value
# (from the first row) and the second one (from the second row)

BertoluzzaDistance(fuzzyValues[1,],fuzzyValues[2,])

# calculate the mid/spread distance between the first value
# (from the first row) and all of the values (from the first to the third row)

BertoluzzaDistance(fuzzyValues[1,],fuzzyValues)


}
\references{
Bertoluzza, C., Corral, N., Salas, A. (1995)
On a new class of distances between fuzzy numbers
Mathware and Soft Computing, 2 (2), pp. 71-84
}
