% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_poisson_gaga}
\alias{cpp_poisson_gaga}
\title{Fit a poisson model via the GAGA algorithm using cpp}
\usage{
cpp_poisson_gaga(
  X,
  y,
  s_alpha,
  s_itrNum,
  s_thresh,
  s_flag,
  s_lamda_0,
  s_fdiag,
  s_subItrNum
)
}
\arguments{
\item{X}{Input matrix, of dimension nobs*nvars; each row is an observation.
If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.
In order to run the program stably, it is recommended that the value of X should not be too large. It is recommended to
preprocess all the items in X except the intercept item by means of preprocessing, so that the mean value of each column
is 0 and the standard deviation is \code{1/ colnum(X)}.}

\item{y}{Non-negative count response vector.}

\item{s_alpha}{Hyperparameter. The suggested value for alpha is 1 or 2.
When the collinearity of the load matrix is serious, the hyperparameters can be selected larger, such as 5.}

\item{s_itrNum}{The number of iteration steps. In general, 20 steps are enough.
If the condition number of \code{X} is large, it is recommended to greatly increase the
number of iteration steps.}

\item{s_thresh}{Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.}

\item{s_flag}{It identifies whether to make model selection. The default is \code{TRUE}.}

\item{s_lamda_0}{The initial value of the regularization parameter for ridge regression.
The running result of the algorithm is not sensitive to this value.}

\item{s_fdiag}{It identifies whether to use diag Approximation to speed up the algorithm.}

\item{s_subItrNum}{Maximum number of steps for subprocess iterations.}
}
\value{
Coefficient vector.
}
\description{
Fit a poisson model the Global Adaptive Generative Adjustment algorithm
}
