% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapping_among_groups.R
\name{overlapping_among_groups}
\alias{overlapping_among_groups}
\title{Overlapping between grouping factors}
\usage{
overlapping_among_groups(file, x, y)
}
\arguments{
\item{file}{A dataframe with the data and grouping factor}

\item{x}{The grouping factor to be compared}

\item{y}{The data to be compared among the levels of the grouping factor}
}
\value{
A list with three matrices: 1) A matrix with the number of overlapping data; 2) A matrix with the percentage of overlapping; 3) A matrix with the combination of the two previous one
}
\description{
Takes a dataframe with a column of genes, QTLs (or other data) and a grouping column and create some matrices with the overlapping information
}
\examples{
data(QTLmarkers)
data(gtfGenes)
genes.out <- find_genes_qtls_around_markers(db_file=gtfGenes,
marker_file=QTLmarkers,method="gene",
marker="snp",interval=100000, nThreads=NULL)
overlapping.out<-overlapping_among_groups(file=genes.out,x="Reference",
y="gene_id")
}
