#' Genotypes at FGFR2 SNPs for subjects from 'GBR' population in the 1000 Genomes Project.
#'
#' A dataset containing the genotypes (number of minor alleles) for each of 91 subjects
#' from the 'GBR' population in the 1000 Genomes Projects.  There are 64 SNPs documented
#' here, all residing in the FGFR2 gene.
#'
#' @format A matrix with 91 rows (one for each subject) and 64 columns (one for each SNP)
#'
#' @docType data
#' @keywords datasets
#' @name FGFR2
#' @usage data(FGFR2)
#' @source \url{http://www.internationalgenome.org/data}
NULL





#' Simulated Principal Components for 'GBR' population in the 1000 Genomes Project.
#'
#' A dataset containing 5 simulated Principal Components (PCs) for each of 91 subjects
#' from the 'GBR' population in the 1000 Genomes Projects.  These would normally be
#' used as covariates in a regression model to control for population stratification.
#'
#' @format A matrix with 91 rows (one for each subject) and 5 columns (one for each PC)
#'
#' @docType data
#' @keywords datasets
#' @name gbr_pcs
#' @usage data(gbr_pcs)
NULL
