% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_var_nonzero_mu.R
\name{calc_var_nonzero_mu}
\alias{calc_var_nonzero_mu}
\title{calc_var_mu_nonzero.R}
\usage{
calc_var_nonzero_mu(d, t, mu, pairwise_cors)
}
\arguments{
\item{d}{The number of test statistics in the set.}

\item{t}{The threshold which determines the properties of S(t).}

\item{mu}{The common mean of the test statistics Z_1,...,Z_d}

\item{pairwise_cors}{A vector of all d(d-1)/2 pairwise correlations between the test 
statistics, where d is total number of test statistics in the set.}
}
\value{
The variance of S(t) when the Z_1,...,Z_d have nonzero mean mu.
}
\description{
Internal function to calculate variance of S(t) when the Z_1,...,Z_d have nonzero mean.  
See GBJ paper for more details.  Vectorized in t.
}
\examples{
calc_var_nonzero_mu(d=5, t=1, mu=1, pairwise_cors=rep(0.3, 10))
}
\keyword{internal}
