% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_functions.R
\name{BS_local_factor}
\alias{BS_local_factor}
\title{Get a bootstrap confidence interval for the local factors}
\usage{
BS_local_factor(object, i, t, BB = 599, alpha = 0.05)
}
\arguments{
\item{object}{An S3 object of class 'multi_result' created by multilevel().}

\item{i}{An integer indicating the \eqn{i}-th block.}

\item{t}{An integer specifying the time point at which the CI is constructed.}

\item{BB}{An integer indicating the number of bootstrap repetition. 599 by default.}

\item{alpha}{The significance level, a single numeric between 0 and 1. 0.05 by default.}
}
\value{
A matrix containing the upper and lower band.
}
\description{
This function employs a bootstrap procedure to obtain confidence intervals
for the local factors in block \eqn{i} at time \eqn{t}. See Lin and Shin (2023) for details.
}
\examples{
\donttest{
panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
bs_local_factor_11 <- BS_local_factor(est_multi, i = 1, t = 1)
}
}
\references{
Lin, R. and Shin, Y., 2022. Generalised Canonical Correlation Estimation
of the Multilevel Factor Model. Available at SSRN 4295429.
}
