% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemOpenEconomy_4_4.R
\name{gemOpenEconomy_4_4}
\alias{gemOpenEconomy_4_4}
\title{A 4-by-4 Open Economy with Bond}
\usage{
gemOpenEconomy_4_4(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
Some examples of a 4-by-4 open economy with bond.
}
\examples{
\donttest{
#### an open economy with foreign bond (bond.ROW)
dst.firm <- node_new(
  "output",
  type = "SCES", alpha = 1, beta = c(0.5, 0.5), es = 1,
  "prod.CHN", "lab"
)

dst.consumer <- node_new(
  "util",
  type = "FIN", beta = c(0.8, 0.2),
  "cc1", "bond.ROW"
)
node_set(dst.consumer, "cc1",
         type = "SCES", alpha = 1, beta = c(0.5, 0.5), es = 1,
         "prod.CHN", "prod.ROW"
)

dst.FT <- node_new(
  "prod.ROW",
  type = "SCES", alpha = 1, beta = c(2/3, 1/3), es = 1,
  "prod.CHN", "lab"
)

dst.Bond <- node_new(
  "util",
  type = "SCES", alpha = 1, beta = c(2/3, 1/3), es = 1,
  "prod.CHN", "lab"
)

ge.open <- sdm2(
  A = list(dst.firm, dst.consumer, dst.FT, dst.Bond),
  B = matrix(c(
    1, 0, 0, 0,
    0, 0, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 0
  ), 4, 4, TRUE),
  S0Exg = matrix(c(
    NA, NA, NA, NA,
    NA, 300, NA, NA,
    NA, NA, NA, NA,
    NA, NA, NA, 60
  ), 4, 4, TRUE),
  names.commodity = c("prod.CHN", "lab", "prod.ROW", "bond.ROW"),
  names.agent = c("firm", "consumer", "FT", "Bond"),
  numeraire = "lab"
)

ge.open$D
ge.open$p

## a corresponding two-country model
dst.firm <- node_new(
  "output",
  type = "SCES", alpha = 1, beta = c(0.5, 0.5), es = 1,
  "prod", "lab"
)

dst.consumer <- node_new(
  "util",
  type = "FIN", beta = c(0.8, 0.2),
  "cc1", "bond.ROW"
)
node_set(dst.consumer, "cc1",
         type = "SCES", alpha = 1, beta = c(0.5, 0.5), es = 1,
         "prod", "prod.ROW"
)

dst.firm.ROW <- node_new(
  "prod.ROW",
  type = "SCES", alpha = 1, beta = c(0.25, 0.25, 0.5), es = 1,
  "prod", "prod.ROW", "lab.ROW"
)

dst.consumer.ROW <- node_new(
  "util",
  type = "SCES", alpha = 1, beta = c(0.25, 0.25, 0.25, 0.25), es = 1,
  "prod", "prod.ROW", "lab", "lab.ROW"
)

ge <- sdm2(
  A = list(dst.firm, dst.consumer, dst.firm.ROW, dst.consumer.ROW),
  B = matrix(c(
    1, 0, 0, 0,
    0, 0, 0, 0,
    0, 0, 1, 0,
    0, 0, 0, 0,
    0, 0, 0, 0
  ), 5, 4, TRUE),
  S0Exg = matrix(c(
    NA, NA, NA, NA,
    NA, 300, NA, NA,
    NA, NA, NA, NA,
    NA, NA, NA, 180,
    NA, NA, NA, 60
  ), 5, 4, TRUE),
  names.commodity = c("prod", "lab", "prod.ROW", "lab.ROW", "bond.ROW"),
  names.agent = c("firm", "consumer", "firm.ROW", "consumer.ROW"),
  numeraire = "lab"
)

ge$D
ge$p

#### an open economy with domestic bond (bond.CHN)
dst.firm <- node_new(
  "output",
  type = "CD", alpha = 5, beta = c(0.5, 0.5),
  "prod.CHN", "lab"
)

dst.consumer <- node_new(
  "util",
  type = "CD", alpha = 1, beta = c(0.5, 0.5),
  "prod.CHN", "prod.ROW"
)

dst.FT <- node_new(
  "prod.ROW",
  type = "Leontief", a = 2,
  "prod.CHN"
)

dst.Bond <- node_new(
  "prod.ROW",
  type = "Leontief", a = 1,
  "bond.CHN"
)

ge <- sdm2(
  A = list(dst.firm, dst.consumer, dst.FT, dst.Bond),
  B = matrix(c(
    1, 0, 0, 0,
    0, 0, 0, 0,
    0, 0, 1, 1,
    0, 0, 0, 0
  ), 4, 4, TRUE),
  S0Exg = matrix(c(
    NA, NA, NA, NA,
    NA, 1, NA, NA,
    NA, NA, NA, NA,
    NA, 0.2, NA, NA
  ), 4, 4, TRUE),
  names.commodity = c("prod.CHN", "lab", "prod.ROW", "bond.CHN"),
  names.agent = c("firm", "consumer", "FT", "Bond"),
  numeraire = "lab"
)

ge$D
ge$p
}
}
