% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_to_dstl.R
\name{matrix_to_dstl}
\alias{matrix_to_dstl}
\title{Convert a Matrix into a Demand Structural Tree List}
\usage{
matrix_to_dstl(
  x,
  names.commodity = paste("comm", 1:nrow(x), sep = ""),
  names.agent = paste("agt", 1:ncol(x), sep = "")
)
}
\arguments{
\item{x}{a matrix.}

\item{names.commodity}{names of commodities.
They will be the names of leaf nodes of each demand structural tree.}

\item{names.agent}{names of agents.
They will be the names of root nodes of those demand structural trees.}
}
\value{
A demand structural tree list.
}
\description{
Convert a demand coefficient matrix into a demand structural tree list.
}
\examples{
\donttest{
A <- matrix(c(
  0, 0, 0, 1,
  8, 6, 1, 0,
  4, 2, 1.5, 0,
  2, 1.5, 0.5, 0
), 4, 4, TRUE)

dstl <- matrix_to_dstl(A)
node_print(dstl[[1]])
}

}
