% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePolicyHeadTailAdjustment.R
\name{makePolicyHeadTailAdjustment}
\alias{makePolicyHeadTailAdjustment}
\title{Make a Policy of Head and/or Tail Adjustment for a Timeline Model}
\usage{
makePolicyHeadTailAdjustment(type = c("both", "tail", "head"), gr = 0, np)
}
\arguments{
\item{type}{a string to specify the type of the policy.}

\item{gr}{the growth rate.}

\item{np}{the number of (internal) periods.}
}
\value{
A policy, which is often used as an argument of the function sdm2.
}
\description{
Make a policy of head and/or tail adjustment for a timeline model.
A timeline model is an intertemporal non-sequential model that includes production and a given initial product supply.
Head adjustment refers to the adjustment of the initial product supply to a steady-state value.
Similarly, tail adjustment refers to the adjustment of the share coefficient of the last period of the consumer in the timeline model in order to let the model run in a steady-state equilibrium path.
}
\seealso{
{
\code{\link{gemIntertemporal_Dividend}};
\code{\link{gemIntertemporal_Money_Dividend_Example7.5.1}}
}
}
