#' @export
#' @title A Disequilibrium Model Illustrating Insufficient Effective Demand (Supply-demand Structural Mismatch)
#' @aliases demInsufficientEffectiveDemand_3_3
#' @description  A disequilibrium model illustrating supply-demand structural mismatch and insufficient effective demand.
#' Assume that from the 5th period, the producer expects the sales rate of products to decline,
#' so he reduces investment in production and increases the demand for value storage means (such as foreign assets, gold, etc.);
#' the laborer expects the unemployment rate to rise, so he reduces consumption and increases the demand for value storage means.
#'
#' Here the supplier of value storage means is referred to as ROW (the rest of the world).
#' @param ... arguments to be passed to the function sdm2.
#' @examples
#' \donttest{
#' dst.firm <- node_new("output",
#'   type = "FIN", rate = c(1, 0),
#'   "cc1", "store of value"
#' )
#' node_set(dst.firm, "cc1",
#'   type = "CD", alpha = 2,
#'   beta = c(0.5, 0.5),
#'   "prod", "lab"
#' )
#'
#' dst.laborer <- node_new("util",
#'   type = "FIN", rate = c(1, 0),
#'   "cc1", "store of value"
#' )
#' node_set(dst.laborer, "cc1",
#'   type = "CD", alpha = 1,
#'   beta = c(0.5, 0.5),
#'   "prod", "lab"
#' )
#'
#' dst.ROW <- node_new("util",
#'   type = "Leontief", a = 1,
#'   "lab"
#' )
#'
#' policy.demand <- function(time, A, state) {
#'   if (time >= 5) {
#'     A[[1]]$rate <- c(1, 0.25)
#'     A[[2]]$rate <- c(1, 0.25)
#'   } else {
#'     A[[1]]$rate <- c(1, 0)
#'     A[[2]]$rate <- c(1, 0)
#'   }
#'
#'   state
#' }
#'
#' ge <- sdm2(
#'   A = list(dst.firm, dst.laborer, dst.ROW),
#'   B = matrix(c(
#'     1, 0, 0,
#'     0, 0, 0,
#'     0, 0, 0
#'   ), 3, 3, TRUE),
#'   S0Exg = matrix(c(
#'     NA, NA, NA,
#'     NA, 100, NA,
#'     NA, NA, 100
#'   ), 3, 3, TRUE),
#'   names.commodity = c("prod", "lab", "store of value"),
#'   names.agent = c("firm", "laborer", "ROW"),
#'   ts = TRUE,
#'   policy = policy.demand,
#'   numberOfPeriods = 100,
#'   maxIteration = 1,
#'   numeraire = "prod",
#'   z0 = c(100, 0, 0),
#'   p0 = c(1, 1, 1),
#'   pExg = c(1, NA, 1)
#' )
#'
#' matplot(ge$ts.z, type = "o", pch = 20)
#' matplot(ge$ts.p, type = "o", pch = 20)
#' matplot(ge$ts.q, type = "o", pch = 20)
#' }

demInsufficientEffectiveDemand_3_3 <- function(...) sdm2(...)
