% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemInputOutputTable_2_7_4.R
\name{gemInputOutputTable_2_7_4}
\alias{gemInputOutputTable_2_7_4}
\title{A Two-Country General Equilibrium Model}
\usage{
gemInputOutputTable_2_7_4(
  IT,
  OT,
  es.DIProduct.production.CHN = 3,
  es.DIProduct.production.ROW = 3,
  es.laborCapital.production.CHN = 0.75,
  es.laborCapital.production.ROW = 0.75,
  es.consumption.CHN = 3,
  es.consumption.ROW = 3,
  es.investment.CHN = 3,
  es.investment.ROW = 3,
  return.dstl = FALSE,
  ...
)
}
\arguments{
\item{IT}{the input part of the input-output table.}

\item{OT}{the output part of the input-output table.}

\item{es.DIProduct.production.CHN}{the elasticity of substitution between
domestic product and imported product used by the production sector of CHN.}

\item{es.DIProduct.production.ROW}{the elasticity of substitution between
domestic product and imported product used by the production sector of ROW.}

\item{es.laborCapital.production.CHN}{the elasticity of substitution between
labor and capital goods used by the production sector of CHN.}

\item{es.laborCapital.production.ROW}{the elasticity of substitution between
labor and capital goods used by the production sector of ROW.}

\item{es.consumption.CHN}{the elasticity of substitution between
domestic product and imported product used by the consumption sector of CHN.}

\item{es.consumption.ROW}{the elasticity of substitution between
domestic product and imported product used by the consumption sector of ROW.}

\item{es.investment.CHN}{the elasticity of substitution between
domestic product and imported product used by the investment sector of CHN.}

\item{es.investment.ROW}{the elasticity of substitution between
domestic product and imported product used by the investment sector of ROW.}

\item{return.dstl}{If TRUE, the demand structure tree will be returned.}

\item{...}{arguments to be transferred to the function \code{\link{sdm2}}.}
}
\value{
A general equilibrium, which usually is a list with the following elements:
\itemize{
\item p - the price vector with CHN labor as numeraire.
\item dstl - the demand structure tree list of sectors if return.dstl == TRUE.
\item ... - some elements returned by the function \code{\link{sdm2}}.
}
}
\description{
A two-country general equilibrium model.
This general equilibrium model is based on a two-country (i.e. CHN and ROW) input-output table consisting of an input part and an output part.
Each country contains 4 sectors and 7 commodities (or subjects).
The 4 sectors are production, consumption, investment and foreign trade.
The 7 commodities (or subjects) are product, labor, capital goods, bond, tax, dividend, imported product.
Hence the input-output table has 14 rows and 8 columns.
}
\examples{
\donttest{
IT <- matrix(c(
  30, 12, 9, 0, 0, 0, 0, 13,
  15, 0, 0, 0, 0, 0, 0, 0,
  2, 0, 0, 0, 0, 0, 0, 0,
  0, 9, 0, 0, 0, 2, 0, 0,
  3, 0, 0, 1, 0, 0, 0, 0,
  6, 0, 0, 0, 0, 0, 0, 0,
  8, 3, 3, 0, 0, 0, 0, 0,
  0, 0, 0, 13, 150, 316, 258, 0,
  0, 0, 0, 0, 288, 0, 0, 0,
  0, 0, 0, 0, 92, 0, 0, 0,
  0, 2, 0, 0, 0, 269, 0, 0,
  0, 0, 0, 0, 35, 0, 0, 1,
  0, 0, 0, 0, 172, 0, 0, 0,
  0, 0, 0, 0, 1, 5, 13, 0
), 14, 8, TRUE)

OT <- matrix(c(
  64, 0, 0, 0, 0, 0, 0, 0,
  0, 15, 0, 0, 0, 0, 0, 0,
  0, 2, 0, 0, 0, 0, 0, 0,
  0, 0, 11, 0, 0, 0, 0, 0,
  0, 3, 0, 0, 0, 0, 0, 0,
  0, 6, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 13, 0, 0, 0, 0,
  0, 0, 0, 0, 738, 0, 0, 0,
  0, 0, 0, 0, 0, 288, 0, 0,
  0, 0, 0, 0, 0, 92, 0, 0,
  0, 0, 0, 0, 0, 0, 271, 0,
  0, 0, 0, 0, 0, 36, 0, 0,
  0, 0, 0, 0, 0, 172, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 14
), 14, 8, TRUE)

dimnames(IT) <- dimnames(OT) <- list(
  c(
    "product.CHN", "labor.CHN", "capital.CHN", "bond.CHN",
    "tax.CHN", "dividend.CHN", "imported.product.CHN",
    "product.ROW", "labor.ROW", "capital.ROW", "bond.ROW",
    "tax.ROW", "dividend.ROW", "imported.product.ROW"
  ),
  c(
    "production.CHN", "consumption.CHN", "investment.CHN", "foreign.trade.CHN",
    "production.ROW", "consumption.ROW", "investment.ROW", "foreign.trade.ROW"
  )
)

ge <- gemInputOutputTable_2_7_4(IT, OT, return.dstl = TRUE)
ge$p
ge$z
node_plot(ge$dstl[[1]])
ge$dstl[[1]]$a

#### technology progress in CHN
OT.TP <- OT
OT.TP["product.CHN", "production.CHN"] <- OT["product.CHN", "production.CHN"] * 1.2

ge.TP <- gemInputOutputTable_2_7_4(IT, OT.TP, return.dstl = TRUE)
ge.TP$p
ge.TP$z
ge.TP$dstl[[1]]$a

#### capital accumulation in CHN
OT.CA <- OT
OT.CA["capital.CHN", "consumption.CHN"] <- OT["capital.CHN", "consumption.CHN"] * 2

ge.CA <- gemInputOutputTable_2_7_4(IT, OT.CA)
ge.CA$p
ge.CA$z

#### labor supply change in CHN
OT.LSC <- OT
OT.LSC["labor.CHN", "consumption.CHN"] <- OT["labor.CHN", "consumption.CHN"] * 0.5

ge.LSC <- gemInputOutputTable_2_7_4(IT, OT.LSC)
ge.LSC$p
ge.LSC$z

#### tariff rate change in CHN
IT.TRC <- IT
IT.TRC["tax.CHN","foreign.trade.CHN"] <- IT.TRC["tax.CHN","foreign.trade.CHN"] * 1.2
ge.TRC <- gemInputOutputTable_2_7_4(IT.TRC, OT)
ge.TRC$p
ge.TRC$z
}

}
