% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsGENEA.R
\name{head.GENEAbin}
\alias{head.GENEAbin}
\title{Get features of a GENEActiv bin data object.}
\usage{
\method{head}{GENEAbin}(x, ...)
}
\arguments{
\item{x}{GENEActiv bin list object}

\item{\dots}{additional arguments}
}
\value{
list showing the first part of each list element.
}
\description{
Shows the first n elements of a GENEActiv bin (list) data object.
}
\examples{
temp <- list(Data = matrix(rnorm(40), ncol = 4), 
    UpDown = rnorm(10), 
    Degrees = sample(-90:90, 10),
    Time = 1:10, 
    Light = runif(10),
    Temp = rep(20, 10),
    Magnitude = runif(10), 
    Serial = "012345",
    RawData = matrix(rnorm(700), ncol = 7),
    Freq = 100)
class(temp) <- c("list", "GENEAbin")
head(x = temp)
}
\keyword{internal}
