% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fboxplot.r
\name{plot.fboxplot}
\alias{plot.fboxplot}
\title{Plot method for the class 'fboxplot'}
\usage{
\method{plot}{fboxplot}(x, digits = 3, outliers = TRUE, ...)
}
\arguments{
\item{x}{an 'fboxplot' object}

\item{digits}{The number of digits used for printing the p-value or p-interval
in the default main.}

\item{outliers}{Logical. If TRUE, then the functions outside the functional boxplot are drawn.}

\item{...}{Ignored.}
}
\description{
Plot method for the class 'fboxplot'
}
\examples{
if(requireNamespace("fda", quietly=TRUE)) {
  years <- paste(1:18)
  curves <- fda::growth[['hgtf']][years,]
  # Heights
  cset1 <- create_curve_set(list(r = as.numeric(years),
                                 obs = curves))
  bp <- fBoxplot(cset1, coverage=0.50, type="area", factor=1)
  plot(bp)
  plot(bp) + ggplot2::theme(legend.position="bottom")
  plot(bp) + ggplot2::theme(legend.position="none")
  plot(bp, plot_outliers=FALSE)
}
}
