% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GE_bias.R
\name{GE_bias}
\alias{GE_bias}
\title{GE_bias.R}
\usage{
GE_bias(beta_list, cov_list, cov_mat_list, mu_list, HOM_list)
}
\arguments{
\item{beta_list}{A list of the effect sizes in the true model.
Use the order beta_0, beta_G, beta_E, beta_I, beta_Z, beta_M.
If Z or M is a vector, then beta_Z and beta_M should be vectors.}

\item{cov_list}{A list of expectations (which happen to be covariances if all covariates
are centered at 0) in the order specified by GE_enumerate_inputs().}

\item{cov_mat_list}{A list of matrices of expectations as specified by GE_enumerate_inputs().}

\item{mu_list}{A list of means as specified by GE_enumerate_inputs().}

\item{HOM_list}{A list of higher order moments as specified by GE_enumerate_inputs().}
}
\value{
A list of the fitted coefficients alpha
}
\description{
A function to calculate the bias in testing for GxE interaction.
}
\examples{
solutions <- GE_bias_normal_squaredmis( beta_list=as.list(runif(n=6, min=0, max=1)), 
						rho_list=as.list(rep(0.3,6)), prob_G=0.3)
GE_bias(beta_list=solutions$beta_list, solutions$cov_list, solutions$cov_mat_list, 
					solutions$mu_list, solutions$HOM_list)
}

