% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GE_BICS_old.R
\name{GE_BICS_old}
\alias{GE_BICS_old}
\title{GE_BICS_old.R}
\usage{
GE_BICS_old(outcome, design_mat, num_boots = 1000, desired_coef,
  outcome_type)
}
\arguments{
\item{outcome}{The outcome vector}

\item{design_mat}{The design matrix of covariates}

\item{num_boots}{The number of bootstrap resamples to perform - we suggest 1000}

\item{desired_coef}{The column in the design matrix holding the interaction covariate}

\item{outcome_type}{Either 'D' for dichotomous outcome or 'C' for continuous outcome}
}
\value{
The p-value for the interaction effect
}
\description{
A function to perform inference on the GxE interaction regression coefficient.
Shows better small sample performance than comparable methods.
}
\examples{
E <- rnorm(n=500)
G <- rbinom(n=500, size=2, prob=0.3)
design_mat <- cbind(1, G, E, G*E)
outcome <- rnorm(500)
GE_BICS_old(outcome=outcome, design_mat=design_mat, desired_coef=4, outcome_type='C')
}
