\name{GGIR}
\alias{GGIR}
\title{
Shell function for analysing an accelerometer dataset.
}
\description{
This function is designed to help users operate all steps of the
analysis. It helps to generate and structure milestone data, 
and produces user-friendly reports. The function acts as a shell with
calls to \link{g.part1}, \link{g.part2}, \link{g.part3},
\link{g.part4} and \link{g.part5}.
}
\usage{
GGIR(mode = 1:5, datadir = c(), outputdir = c(), studyname = c(),
f0 = 1, f1 = 0, do.report = c(2, 4, 5), configfile = c(), myfun = c(), ...)
}
\arguments{
  \item{mode}{
    Specify which of the five parts need to be run, e.g. mode = 1 makes
    that \link{g.part1} is run. Default setting, mode = 1:5, makes
    that the whole GGIR pipeline is run, from \link{g.part1} to \link{g.part5}.
  }
  \item{datadir}{
    Directory where the accelerometer files are stored, e.g. 
    "C:/mydata", or list of accelerometer filenames and directories, e.g. 
    c("C:/mydata/myfile1.bin", "C:/mydata/myfile2.bin").
  }
  \item{outputdir}{
    Directory where the output needs to be stored. Note that this 
    function will attempt to create folders in this directory and uses
    those folder to keep output.
  }
  \item{studyname}{
    If the datadir is a folder, then the study will be given the name of the
    data directory. If datadir is a list of filenames then the studyname as specified
    by this input argument will be used as name for the study
  }  
  \item{f0}{
    File index to start with (default = 1). Index refers to the filenames sorted
    in alphabetical order
  }
  \item{f1}{
    File index to finish with (defaults to number of files available, i.e., f1 = 0)
  }
  \item{do.report}{
    For which parts to generate a summary spreadsheet: 2, 4, and/or 5. Default is c(2, 4, 5).
    A report will be generated based on the available milestone data. When creating 
    milestone data with multiple machines it is advisable to turn the report
    generation off when generating the milestone data, value = c(),
    and then to merge the milestone data and turn report generation back
    on while setting overwrite to FALSE.  
  }
  \item{configfile}{
    Configuration file previously generated by function GGIR. See details.
  }
  \item{myfun}{
    External function object to be applied to raw data. See package vignette for detailed tutorial with examples on how to use the function embedding: https://cran.r-project.org/web/package=GGIR/vignettes/applyExtFunction.pdf
  }
  \item{...}{
    Any of the parameters used GGIR. Given the large number of parameters used in GGIR
    we have grouped them in objects that start with 'params_'. These are documented in the 
    details section. You cannot provide these objects as argument to function GGIR, but you can provide the parameters inside them as input to function GGIR.
  }  
}
\value{
  The function provides no values, it only ensures that other functions are called
  and that their output is stored. Further, a configuration file is stored containing
  all the argument values used to facilitate reproducibility.
}
\details{
  Once you have used function GGIR and the output directory (outputdir) will be filled
  with milestone data and results. Function GGIR stores all the explicitely 
  entered argument values and default values for the argument that are not explicitely
  provided in a csv-file named config.csv stored in the root of the output folder. 
  The config.csv file is accepted as input to GGIR with argument `configfile`
  to replace the specification of all the arguments, except `datadir` and `outputdir`.
  
  The practical value of this is that it eases the replication of analysis, because
  instead of having to share you R script, sharing your config.csv file will be 
  sufficient. Further, the config.csv file contribute to the reproducibility
  of your data analysis.
  
  Note: When combining a configuration file with explicitely provided argument
  values, the explicitely provided argument values will overrule
  the argument values in the configuration file. If a parameter is neither provided
  via the configuration file nor as input then GGIR uses its default paramter values which
  can be inspected with command \code{print(load_params())}, and if you are specifically 
  interested in a certain subgroup of parameters, let's say physical activity, then you
  can do \code{print(load_params()$params_phyact)}. These defaults are part of the GGIR
  code and cannot be changed by the user.
  
  The parameters that can be used in GGIR are:
  \subsection{params_metrics}{
  A list of parameters used to specify the signal metrics that need to be extract in GGIR part 1.
  \describe{
      \item{do.anglex}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.angley}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.anglez}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.zcx}{Boolean, if TRUE calculate metric zero-crossing count for x-axis.
        For computation specifics see source code of function \link{g.applymetrics}}
      \item{do.zcy}{Boolean, if TRUE calculate metric zero-crossing count for y-axis.
        For computation specifics see source code of function \link{g.applymetrics}}
      \item{do.zcz}{Boolean, if TRUE calculate metric zero-crossing count for z-axis.
        For computation specifics see source code of function \link{g.applymetrics}}
      \item{do.enmo}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.lfenmo}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.en}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.mad}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.enmoa}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.roll_med_acc_x}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.roll_med_acc_y}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.roll_med_acc_z}{Boolean, if TRUE calculate metric.
        For computation specifics see source code of function \link{g.applymetrics}}
      \item{do.dev_roll_med_acc_x}{Boolean, if TRUE calculate metric.
        For computation specifics see source code of function \link{g.applymetrics}}
      \item{do.dev_roll_med_acc_y}{Boolean, if TRUE calculate metric.
        For computation specifics see source code of function \link{g.applymetrics}}
      \item{do.dev_roll_med_acc_z}{Boolean, if TRUE calculate metric.
        For computation specifics see source code of function \link{g.applymetrics}}
      \item{do.bfen}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.hfen}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.hfenplus}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.lfen}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.lfx}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.lfy}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.lfz}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.hfx}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.hfy}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.hfz}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.bfx}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.bfy}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.bfz}{Boolean, if TRUE calculate metric. For computation
        specifics see source code of function \link{g.applymetrics}}
      \item{do.brondcounts}{Boolean, if TRUE calculate metric via R
        package activityCounts. We call them BrondCounts because
        there are large number of acitivty counts in the physical activity and
        sleep research field. By calling them _brondcounts_ we clarify that 
        these are the counts proposed by Jan Br&#248;nd and implemented in R by
        Ruben Brondeel. The _brondcounts_ are intended to be an imitation of
        one the counts produced by one of the closed source ActiLife software
        by ActiGraph.}
      \item{lb}{Numeric, lower boundary of the frequency filter (in Hertz) as
        used in the filter-based metrics.}
      \item{hb}{Numeric, higher boundary of the frequency filter (in Hertz) as
        used in the filter-based metrics.}
      \item{n}{Numeric, order of the frequency filter as used in a variety of metrics.}
    }
  }
  
  \subsection{params_rawdata}{
    A list of parameters used to related to reading and pre-processing 
    raw data, excluding parameters related to metrics as those are in
    the params_metrics object.
    \describe{
      \item{backup.cal.coef}{Character. Default value is "retrieve".
        Option to use backed-up calibration coefficient instead of
        deriving the calibration coefficients when analysing the same file twice.
        Argument backup.cal.coef has two usecase. Use case 1: If the auto-calibration
        fails then the user has the option to provide back-up
        calibration coefficients via this argument. The value of the argument needs to
        be the name and directory of a csv-spreadsheet with the following column names
        and subsequent values: 'filename' with the names of accelerometer files on which
        the calibration coefficients need to be applied in case auto-calibration fails;
        'scale.x', 'scale.y', and 'scale.z' with the scaling coefficients; 'offset.x',
        'offset.y', and 'offset.z' with the offset coefficients, and;
        'temperature.offset.x', 'temperature.offset.y', and 'temperature.offset.z'
        with the temperature offset coefficients. This can be useful for analysing
        short lasting laboratory experiments with insufficient sphere data to perform
        the auto-calibration, but for which calibration coefficients can be derived
        in an alternative way.  It is the users responsibility to compile the
        csv-spreadsheet. Instead of building this file the user can also
        Use case 2: The user wants to avoid performing the auto-calibration repeatedly
        on the same file. If backup.cal.coef value is set to "retrieve" (default) then
        GGIR will look out for the  data_quality_report.csv  file in the outputfolder
        QC, which holds the previously generated calibration coefficients. If you
        do not want this happen, then deleted the data_quality_report.csv from the
        QC folder or set it to value "redo".}
      \item{minimumFileSizeMB}{Numeric. Minimum File size in MB required to enter processing,
        default 2MB. This argument can help
        to avoid having short uninformative files to enter the analyses. Given that a typical accelerometer
        collects several MBs per hour, the default setting should only skip the very tiny files.}
      \item{do.cal}{Boolean. Whether to apply auto-calibration or not by \link{g.calibrate}. Default and
        recommended setting is TRUE.}
      \item{imputeTimegaps}{Boolean to indicate whether timegaps larger than 1 sample should be imputed.
        Currently onlly used for .gt3x data and ActiGraph .csv format, where timegaps can be expected as a result of
        Actigraph's idle sleep.mode configuration that is turned on in some studies.}
      \item{spherecrit}{The minimum required acceleration value (in g) on both sides of 0 g
        for each axis. Used to judge whether the sphere is sufficiently populated}
      \item{minloadcrit}{The minimum number of hours the code needs to read for the
        autocalibration procedure to be effective (only sensitive to multitudes of 12 hrs, 
        other values will be ceiled). After loading these hours only extra data is loaded 
        if calibration error has not been reduced to under 0.01 g.}
      \item{printsummary}{Boolean (default = FASE). If TRUE will print a summary of the calibration procedure when done}
      \item{chunksize}{Numeric. Value between 0.2 and 1 to specificy the size of chunks to be 
        loaded as a fraction of a 12 hour period, e.g. 0.5 equals 6 hour chunks.
        The default is 1 (12 hrs). For machines with less than 4Gb of RAM memory a value
        below 1 is recommended.}
      \item{dynrange}{Numeric, provide dynamic range for accelerometer data to
        overwrite hardcoded 6 g for GENEA and 8 g for other brands}
      \item{interpolationType}{Integer to indicate type of interpolation to be used
        when resampling time series (mainly relevant for Axivity sensors),
        1=linear, 2=nearest neighbour}
      \item{all arguments that start with "rmc.".}{see function \link{read.myacc.csv} and
      \link{get_nw_clip_block_params}}
    }
  }   
  \subsection{params_cleaning}{
    A list of parameters used across all GGIR parts releated to masking or 
    imputing data, abbreviated as 'cleaning'.
    \describe{
      \item{do.imp}{Boolean. Whether to impute missing values (e.g. suspected of monitor non-wear) or not
        by \link{g.impute} in GGIR part2. Default and recommended setting is TRUE}
      \item{TimeSegments2ZeroFile}{Character. Path to csv-file holding the data.frame used for argument
        TimeSegments2Zero in function \link{g.impute}}
      \item{data_cleaning_file}{Character. Optional path to a csv file you create that holds four
        columns: ID, day_part5, relyonguider_part4, and night_part4. ID should hold the participant ID.
        Columns day_part5 and night_part4 allow you to specify which day(s) and
        night(s) need to be excluded from part 5 and 4, respectively. So, this will be done regardless
        of whether the rest of GGIR thinks those day(s)/night(s)
        are valid. Column relyonguider_part4 allows you to specify for which nights
        part 4 should fully rely on the guider. See also package vignette.}
      \item{excludefirstlast.part5}{Boolean. If TRUE then the first and last window 
      (waking-waking or midnight-midnight) are ignored in part 5.}
      \item{excludefirstlast}{Boolean. If TRUE then the first and last night of the measurement are ignored for the sleep assessment (part 4).}
      \item{excludefirst.part4}{Boolean. If TRUE then the first night of the measurement are
        ignored for the sleep assessment (part 4.}
      \item{excludelast.part4}{Boolean. If TRUE then the last night of the measurement are
        ignored for the sleep assessment.}
      \item{includenightcrit}{Numeric. Minimum number of valid hours per night (24 hour window between
        noon and noon), used for sleep assessment (part 4).}
      \item{minimum_MM_length.part5}{Numeric. Minimum length in hours of a MM day to be included in the cleaned part 5 results.}
      \item{selectdaysfile}{Character, Functionality designed for the London Centre
        of Longidutinal studies. Csv file holding the relation between device 
        serial numbers and measurement days of interest.}
      \item{strategy}{Numeric, how to deal with knowledge about study protocol.
        value = 1 means select data based on \code{hrs.del.start} and \code{hrs.del.end}.
        Value = 2 makes that only the data between the first
        midnight and the last midnight is used for imputation. Value = 3 only selects
        the most active X days in the file where X is specified by argument \code{ndayswindow}. 
        Value = 4 to only use the data after the first midnight. Used in GGIR part 2}
      \item{hrs.del.start}{Numeric, how many HOURS after start of experiment did wearing
        of monitor start? Used in GGIR part 2}
      \item{hrs.del.end}{Numeric, how many HOURS before the end of the experiment did 
        wearing of monitor definitely end? Used in GGIR part 2}
      \item{maxdur}{Numeric, How many DAYS after start of experiment did experiment
        definitely stop? (set to zero if unknown = default). Used in GGIR part2}
      \item{ndayswindow}{Numeric,  If \code{strategy} is set to 3 then this is the 
        size of the window as a number of days. Used in GGIR part2}
      \item{includedaycrit.part5}{
        Inclusion criteria for number of valid hours, either
    as expressed as a ratio of 1 or as the number of hours in a 24 hour day.
      }
      \item{includedaycrit}{Numeric, minimum required number of valid hours
        in day specific analysis (NOTE: there is no minimum required number of
        hours per day in the summary of an entire measurement, every available 
        hour is used to make the best possible inference on average metric value
        per average day)}
        \item{max_calendar_days}{Numeric, the maximum number of calendar days to include}
    }
  }
   \subsection{params_general}{
    A list of parameters used across all GGIR parts that do not fall in any of the other
    categories.
    \describe{
      \item{overwrite}{Boolean (default = FALSE). Do you want to overwrite analysis for which milestone 
        data exists? If overwrite=FALSE, then milestone data from a previous analysis will
        be used if available and visual reports will not be created again.}
      \item{selectdaysfile}{Character. Do not use, this is legacy code for one specific data study.
        Character pointing at a csv file holding the relationship between device serial
        numbers (first column) and measurement dates of interest
        (second and third column). The date format should be dd/mm/yyyy. And the first row
        if the csv file is assumed to have a character variable names, e.g. "serialnumber"
        "Day1" and "Day2" respectively. Raw data will be extracted and stored in the output
        directory in a new subfolder named 'raw'.}
      \item{dayborder}{Numeric. Hour at which days start and end (default = 0), 
      value = 4 would mean 4 am}
      \item{do.parallel}{Boolean. whether to use multi-core processing
        (only works if at least 4 CPU cores are available).}
      \item{maxNcores}{Numeric. Maximum number of cores to use when argument do.parallel is set to true.
        GGIR by default uses either the maximum number of available cores or the number of files to 
        process (whichever is lower), but this argument allows you to set a lower maximum.}
      \item{acc.metric}{Boolean. Which one of the metrics do you want to consider to analyze L5.
        The metric of interest need to be calculated in M.}
      \item{part5_agg2_60seconds}{Boolean. Wether to use aggregate epochs to 60 seconds
        as part of the part 5 analysis.}
      \item{print.filename}{Boolean (default = FALSE). Whether to print the filename before before analysing
        it (default is FALSE). Printing the filename can be useful to investigate
        problems (e.g. to verify that which file is being read).}
      \item{desiredtz}{Character, desired timezone: see also http://en.wikipedia.org/wiki/Zone.tab}
      \item{configtz}{Character, Only functional for AX3 cwa data at the moment. 
        Timezone in which the accelerometer was configured. Only use this argument
        if the timezone of configuration and timezone in which recording took
        place are different.}
      \item{sensor.location}{
      Character to indicate sensor location, default is wrist.
    If it is hip HDCZA algorithm also requires longitudinal axis of sensor to be
    between -45 and +45 degrees.
      }
      \item{acc.metric}{
      Which one of the metrics do you want to consider to analyze L5. 
    The metric of interest need to be calculated in
    M (see \link{g.part1})
      }
      \item{windowsizes}{Numeric vector, three values to indicate the lengths of the 
        windows as in c(window1,window2,window3): window1 is the short epoch length
        in seconds and by default 5 this is the time window over which acceleration and
        angle metrics are calculated, window2 is the long epoch length in seconds 
        for which non-wear and signal clipping are defined, default 900. However, 
        window3 is the window length of data used for non-wear detection and by default
        3600 seconds. So, when window3 is larger than window2 we use overlapping windows,
        while if window2 equals window3 non-wear periods are assessed by non-overlapping
        windows. Window2 is expected to be a multitude of 60 seconds.}
      \item{idloc}{Numeric (default: idloc = 1). If idloc = 1 the code assumes that ID
        number is stored in the obvious header field. Note that for ActiGraph data
        the ID never stored in the file header. For value set to 2, 5, 6, and 7, GGIR
        looks at the filename and extracts the character string preceding the first 
        occurance of a '_' (idloc = 2), ' ' (space, idloc = 5), '.' (dot, idloc = 6), 
        and '-' (idloc = 7), respecitvely. You may have 
        noticed that idloc 3 and 4 are skipped, they were used for one study in 2012,
        and not actively maintained anymore, but because it is legacy code not omitted.}
    }
  }
  \subsection{params_output}{
    A list of parameters used to specify whether and how GGIR stores its output at various stages of the
    process.
    \describe{
      \item{storefolderstructure}{Boolean. Store folder structure of the accelerometer data.}
      \item{do.part3.pdf}{Boolean. In g.part3: Whether to generate a pdf for part 3 (default is TRUE).}
      \item{timewindow}{In g.part5: Timewindow over which summary statistics are derived.
        Value can be "MM" (midnight to midnight), "WW" (waking time to waking time), 
        or both c("MM","WW").}
      \item{save_ms5rawlevels}{Boolean, whether to save the time series 
        classification (levels) as a csv files.}
      \item{save_ms5raw_format}{Character string to specify how data should
        be stored: either "csv" (default) or "RData". Only used if save_ms5rawlevels=TRUE.}
      \item{save_ms5raw_without_invalid}{Boolean to indicate whether to remove
        invalid days from the time series output files. Only used if save_ms5rawlevels=TRUE.}
      \item{epochvalues2csv}{Boolean (default: epochvalues2csv = FALSE). If TRUE then epoch values
        are exported to a CSV spreadsheet. Here, non-wear time is imputed where possible.}
      \item{do.sibreport}{Boolean (default: do.sibreport = FALSE). Applied in g.part5 to indicate
        whether to generate report for the sustained inactivity bouts (sib).}
      \item{do.visual}{Boolean. If g.part4 is run with do.visual == TRUE (default) then
        the function will generate a pdf with a visual representation of the
        overlap between the sleeplog entries and the accelerometer detections.
        This can be used to visualy verify that the sleeplog entries do
        not come with obvious mistakes.}
      \item{outliers.only}{Boolean. Relevant for do.visual == TRUE. Outliers.only == FALSE
        will visualise all available nights in the data. Outliers.only == TRUE will visualise
        only for nights with a difference in onset or waking time
        larger than the variable of argument criterror.}
      \item{criterror}{Numeric. Relevant for do.visual == TRUE and outliers.only == TRUE.
        criterror specifies the number of minimum number of hours difference
        between sleep log and  accelerometer estimate for the night to be
        included in the visualisation.}
      \item{visualreport}{Boolean. If TRUE (default) then generate visual report based on combined output from part 2
        and 4.}
      \item{viewingwindow}{Numeric. Centre the day as displayed around noon (value = 1) or
        around midnight (value = 2).}
      \item{week_weekend_aggregate.part5}{
        Boolean to indicate whether week and weekend-days aggregates
        should be stored. This is turned off by default as it generates a 
        large number of extra columns in the output report.
      }
      \item{dofirstpage}{
        Boolean to indicate whether a first page with histograms summarizing the whole
        measurement should be added in the file summary reports generated with \link{g.plot5}.
      }
      \item{timewindow}{Timewindow over which summary statistics are derived.
        Value can be "MM" (midnight to midnight), "WW" (waking time to waking time),
        or both c("MM","WW").}
    }
  }
  \subsection{params_phyact}{
    A list of parameters releated to physical activity as used in GGIRpart2 and GGIRpart5.
    \describe{
      \item{threshold.lig}{Numeric. In g.part5: Threshold for light physical activity to
        separate inactivity from light. Value can be one number or an array of multiple
        numbers, e.g. threshold.lig =c(30,40). If multiple numbers are entered then
        analysis will be repliced for each combination of threshold values. Threshold is
        applied to the first metric in the milestone data, so if you have only specified
        do.ENMO == TRUE then it will be applied to ENMO.}
      \item{threshold.mod}{Numeric. In g.part5: Threshold for moderate physical activity 
        to separate light from moderate. Value can be one number or an array of 
        multiple numbers, e.g. threshold.mod =c(100,110).
        If multiple numbers are entered then analysis will be repliced for each
        ombination of threshold values. Threshold is applied to the first metric in the
        milestone data, so if you have only specified do.ENMO == TRUE then it will be
        applied to ENMO.}
      \item{threshold.vig}{Numeric. In g.part5: Threshold for vigorous physical activity 
        to separate moderate from vigorous. Value can be one number or an array of 
        multiple numbers, e.g. threshold.mod =c(400,500). If multiple numbers are
        entered then analysis will be repliced for each combination of threshold values.
        Threshold is applied to the first metric in the milestone data, so if you
        have only specified do.ENMO == TRUE then it will be applied to ENMO.}
      \item{closedbout}{
      TRUE if you want breaks in bouts to be counted towards
  time spent in bouts (argument only active for bout.metric 1 and 2)
      }
      \item{frag.metrics}{
      Character with fragmentation metric to exract. Can be "mean", "TP", "Gini", 
   "power", or "CoV", "NFragPM", or all the above metrics with "all". See package vignette for description of fragmentation metrics.
      }
      \item{mvpathreshold}{Numeric, Acceleration threshold for MVPA estimation in GGIR part2.
        This can be a single number or an array of numbers, e.g. c(100,120). In the later case 
        the code will estimate MVPA seperately for each threshold. If this variable 
        is left blank c() then MVPA is not estimated}
      \item{boutcriter}{Numeric, The variable boutcriter is a number between
        0 and 1 and defines what fraction of a bout needs to be above the 
        mvpathreshold, only used in GGIR part 2}
      \item{mvpadur}{Numeric, default = c(1,5,10). Three bout duration for which 
        MVPA will be calculated. Only used in GGIR part 2}
      \item{bout.metric}{Numeric, specify a metric for bout detection. If value=1 the code          uses the MVPA bout definition as has
        been available since 2014 (see papers by Sabia AJE 2014 and da Silva IJE 2014).
        Here, the algorithm looks for 10 minute windows in which more than XX percent
        of the epochs are above mvpathreshold, and then counts the entire window as mvpa.
        If value=2 the code looks for groups of epochs with a value above
        mvpathreshold that span a time window of at least mvpadur minutes in  which
        more than boutcriter percent of the epochs are above the threshold. The motivation 
        for the defition 1 was: A person who spends 10 minutes in MVPA with a 2 minute
        break in the middle is equally active as a person who spends 8 minutes in MVPA
        without taking a break. Therefore, both should be counted equal and counted as
        10 minute MVPA bout. The motivation for the definition 2 is: not counting breaks
        towards MVPA may simplify interpretation and still counts the two persons in
        the example as each others equal. If value=3, using sliding window across the
        data to test bout criteria per window and do not allow for breaks larger than 1 minute
        and with fraction of time larger than the boutcriter threshold.
        If value=4, same as 3 but also requires the first and last epoch to 
        meet the threshold criteria. If value=5, same as 4, but now looks for breaks larger
        than a minute such that 1 minute breaks are allowe, and the fraction of time that meets
        the threshold should be equal than or greater than the bout.criter threshold.
        If value=6, algorithm improved (2021) to check for first and last epoch.
        } 
      \item{boutdur.mvpa}{Numeric, durations of mvpa bouts in minutes to be extracted.
        The default values is c(1,5,10) and will start with the identification of
        10 minute bouts, followed by 5 minute bouts in the rest of the data, and followed
        by 1 minute bouts in the rest of the data.}
      \item{boutdur.in}{Numeric, durations of inactivty bouts in minutes to be
        extracted. Inactivity bouts are detected in the segments of the data which
        were not labelled as sleep or MVPA bouts. The default duration values
        is c(10,20,30), this will start with the identification of 30 minute bouts,
        followed by 20 minute bouts in the rest of the data, and followed by 10 minute
        bouts in the rest of the data.}
      \item{boutdur.lig}{Numeric, durations of light activty bouts in minutes
        to be extracted. Light activity bouts are detected in the segments of the data
        which were not labelled as sleep, MVPA, or inactivity bouts. The default
        duration values is c(1,5,10), this will start with the identification of 
        10 minute bouts, followed by 5 minute bouts in the rest of the data, and followed
        by 1 minute bouts in the rest of the data.}
      \item{boutcriter.in}{Numeric, a number between 0 and 1 and defines what fraction
        of a bout needs to be below the light threshold}
      \item{boutcriter.lig}{Numeric, a number between 0 and 1 and defines what
        fraction of a bout needs to be between the light and moderage threshold}
      \item{boutcriter.mvpa}{Numeric, a number between 0 and 1 and defines
        what fraction of a bout needs to be above the mvpathreshold}
    }
  }
  \subsection{params_247}{
    A list of parameters releated to description of 24/7 behaviours that do not fall
    under conventional physical activity or sleep outcomes, these parameters are used
    in GGIRpart2 and GGIRpart5: 
    \describe{
      \item{qwindow}{Numeric or character, To specify windows over which all
        variables are calculated, e.g. acceleration distirbution, number of valid
        hours, LXMX analysis, MVPA. If value = c(0,24), which is the default, 
        all variables will only be calculated over the full 24 hours in a day, If
        value =c(8,24) variables will be calculated over the window 0-8, 8-24 and 0-24.
        All days in the recording will be segmented based on these values. If you want
        to use a day specific segmentation then you can set qwindow to be
        the full path to activity diary file. Expected format of the activity diary is: 
        First column headers followed by one row per recording, first column is recording ID,
        which needs to match with the ID GGIR extracts from the accelerometer file. Followed 
        by date column in format "23-04-2017", where date format is specified by argument 
        qwindow_dateformat (below). Use the character combination date, Date or DATE in the
        column name. This is followed by one or multiple columns with start times for 
        the activity types in that day format in hours:minutes:seconds. The header of the 
        column will be used as label for each activity type. Insert a new date column before
        continuing with activity types for next day. Leave missing values empty. If an
        activitylog is used then individuals who do not appear in the activitylog will still 
        be processed with value c(0,24). Dates with no activiy log data can be skipped, 
        no need to have a column with the date followed by a column with the next date.
        }
      \item{qwindow_dateformat}{Character specifying the date format used in the activity log.}
      \item{M5L5res}{Numeric, resolution of L5 and M5 analysis in minutes 
        (default: 10 minutes)}
      \item{winhr}{Numeric, Vector of window size(s) (unit: hours) of L5 and
        M5 analysis (dedault = 5 hours)}
      \item{qlevels}{Numeric, array of percentiles for which value needs to be extracted.
        These need to be expressed as a fraction of 1, e.g. c(0.1, 0.5, 0.75). 
        There is no limit to the number of percentiles. If left empty then percentiles will not be 
        extracted. Distribution will be derived from short epoch metric data.}
      \item{ilevels}{Numeric, Levels for acceleration value frequency
        distribution in mg, e.g. c(0,100,200). There is no limit to the number of levels.}
      \item{window.summary.size}{Numeric, Functionality designed for the London Centre
        of Longidutinal studies. Size in minutes of the summary window}
      \item{iglevels}{Numeric, Levels for acceleration value frequency distribution
        in mg used for intensity gradient calculation (according to the method by 
        Rowlands 2018). By default this is argument is empty and the intensity gradient
        calculation is not done. The user can either provide a single value (any) to 
        make the intensity gradient use the bins c(seq(0,4000,by=25),8000) or the 
        user could specify their own distribution. There is no constriction to the 
        number of levels.}
      \item{IVIS_windowsize_minutes}{
        Window size of the Intradaily Variability (IV) and Interdaily
        Stability (IS) metrics in minutes, needs to be able to add up to 24 hours.
      }
      \item{IVIS_epochsize_seconds}{
        This argument is deprecated.
      }
      \item{IVIS.activity.metric}{
        Metric used for activity calculation.
        Value = 1, uses continuous scaled acceleration.
        Value = 2, tries to collapse acceleration into a binary score of rest
        versus active to try to similate the original approach.
      }
      \item{qM5L5}{
        Percentiles (quantiles) to be calculated over L5 and M5 window.
      }
      \item{MX.ig.min.dur}{
        Minimum MX duration needed in order for intensity gradient to be calculated
      }
      \item{LUXthresholds}{Numeric. Vector with numeric sequece corresponding to
        the thresholds used to calculated time spent in LUX ranges.}
      \item{LUX_cal_constant}{Numeric, if both LUX_cal_constant and LUX_cal_exponent are 
        provided LUX LUX values are converted based on formula y = constant * exp(x * exponent)}
      \item{LUX_cal_exponent}{Numeric, if both LUX_cal_constant and LUX_cal_exponent are provided LUX
        LUX values are converted based on formula y = constant * exp(x * exponent)}
      \item{LUX_day_segments}{Numeric vector with hours at which the day should be segmented for
        the LUX analysis.}
      \item{L5M5window}{Argument depricated after version 1.5-24. 
        This argument used to define the start and end time, in 24 hour clock hours,
        over which L5M5 needs to be calculated. Now this is done with argument qwindow}
    }
  }
  \subsection{params_sleep}{
    A list of parameters used to configure the sleep analysis as performend in
    GGIR part 3 and 4.
    \describe{
      \item{relyonguider}{Boolean. If TRUE then sleep onset and waking time are defined based on
        timestamps derived from the guider. If participants were instructed NOT to wear the accelerometer
        during waking hours then set to TRUE, in all other scenarios
        set to FALSE (default).}
      \item{relyonsleeplog}{Do not use, now replaced by argument relyonguider.
        Values provided to argument relyonsleeplog will be passed on to 
        argument relyonguider to not preserve functionality of old R scripts.}
      \item{def.noc.sleep}{Numeric. The time window during which sustained
        inactivity will be assumed to represent sleep, e.g. def.noc.sleep=c(21,9).
        This is only used if no sleep log entry is available. If def.noc.sleep is
        left blank 'def.noc.sleep=c()' then the 12 hour window centred
        at the least active 5 hours of the 24 hour period will be used
        instead. Here, L5 is hardcoded and will not change by changing
        argument winhr in function \link{g.part2}. If def.noc.sleep is filled
        with a single integer, e.g. def.noc.sleep=c(1) then the window
        will be detected with based on built in algorithms.
        See argument HASPT.algo from \link{HASPT} for specifying which of those
        algorithms to use.}
      \item{sleepwindowType}{Character to indicate type of sleeplog, default "SPT".
        Set to "TimeInBed" if sleep log recorded time in bed to enable calculation
        of sleep latency and sleep efficiency.}
      \item{nnights}{Number of nights for which sleep log information should be available. 
        It assumes that this is constant within a study. If sleep log information
        is missing for certain nights then leave these blank.}
      \item{loglocation}{Character. Path to csv file with sleep log
        information. See package vignette for how to format this file.}
      \item{colid}{Numeric. Column number in the sleep log spreadsheet in which
          the participant ID code is stored (default = 1)}
      \item{coln1}{Numeric. Column number in the sleep log spreadsheet where 
          the onset of the first night starts}
      \item{sleeplogidnum}{Boolean. Should the participant identifier as stored in
          the sleeplog be interpretted as a number (TRUE=default) or character (FALSE)?}
      \item{ignorenonwear}{
        If TRUE then ignore detected monitor non-wear periods to avoid
        confusion between monitor non-wear time and sustained inactivity
        (default = TRUE)
      }
      \item{constrain2range}{Boolean,  Whether or not to constrain the range of
        threshold used in the diary free sleep period time window detection}
      \item{HASPT.ignore.invalid}{
        Boolean to indicate whether invalid time segments should be ignored
      }
      \item{HASPT.algo}{Character to indicate what algortihm should be used. Default "HDCZA" is 
        Heuristic algorithm looking at Distribution of Change in Z-Angle as
        described in van Hees et al. 2018. Other options included:
        "HorAngle", which is based on HDCZA but replaces non-movement detection of 
        the HDCZA algorithm by looking for time segments where the angle of the 
        longitudinal sensor axis has an angle relative to the horizontal plane
        between -45 and +45 degrees.
      }
      \item{HASIB.algo}{
        Character to indicator which sib algorithm should be used.
        Default value: "vanHees2015". Other options: "Sadeh1994", "Galland2012"
      }
      \item{Sadeh_axis}{Character, character to indicate which axis to use for
        the Sadeh1994 algorithm, and  other algortihms that related on count-based
        Actigraphy such as Galland2012.}
      \item{sleeplogsep}{
        Value used as sep argument for reading sleeplog csv file, usually "," or ";".
      }
      \item{nap_model}{
        Character to specify classification model. Currently the only option is "hip3yr", which
        corresponds to a model trained with hip data in 3-3.5 olds trained with parent diary data.
      }
      \item{longitudinal_axis}{Integer to indicate which axis is the longitudinal axis. 
        If not provided function will estimate longitudinal axis. Only used when
        sensor.location="hip" or HASPT.algo="HorAngle".} 
      \item{anglethreshold}{Numeric, Angle threshold (degrees) for sustained 
        inactivity periods detection, default = 5. This can be specified
        as multiple thresholds, each of which will be implemented. }
      \item{timethreshold}{Numeric, time threshold (minutes) for sustained
        inactivity periods detection, default = 5. This can be specified
        as multiple thresholds, each of which will be implemented. 
        For example, timethreshold = c(5,10)}
      \item{possible_nap_window}{
        Numeric vector of length two with range in clock hours during which naps are
        assumed to take place, e.g., c(9, 18).
      }
      \item{possible_nap_dur}{
        Numeric vector of length two with range in duration (minutes) of a nap, 
        e.g., c(15, 240)
      }
    }
  }
}
\examples{
\dontrun{
  mode = c(1,2,3,4,5)
  datadir = "C:/myfolder/mydata"
  outputdir = "C:/myresults"
  studyname ="test"
  f0 = 1 
  f1 = 2
  GGIR(#-------------------------------
               # General parameters
               #-------------------------------
               mode=mode, 
               datadir=datadir, 
               outputdir=outputdir, 
               studyname=studyname, 
               f0=f0, 
               f1=f1,
               overwrite = FALSE, 
               do.imp=TRUE,
               idloc=1, 
               print.filename=FALSE,
               storefolderstructure = FALSE,
               #-------------------------------
               # Part 1 parameters:
               #-------------------------------
               windowsizes = c(5,900,3600),
               do.cal=TRUE, 
               do.enmo = TRUE,
               do.anglez=TRUE,
               chunksize=1,
               printsummary=TRUE,
               #-------------------------------
               # Part 2 parameters:
               #-------------------------------
               strategy = 1,
               ndayswindow=7,
               hrs.del.start = 1,
               hrs.del.end = 1, 
               maxdur = 9,
               includedaycrit = 16, 
               L5M5window = c(0,24),
               M5L5res = 10,
               winhr = c(5,10),
               qlevels = c(c(1380/1440),c(1410/1440)),
               qwindow=c(0,24), 
               ilevels = c(seq(0,400,by=50),8000), 
               mvpathreshold =c(100,120),
               #-------------------------------
               # Part 3 parameters:
               #-------------------------------
               timethreshold= c(5,10),
               anglethreshold=5,
               ignorenonwear = TRUE,
               #-------------------------------
               # Part 4 parameters:
               #-------------------------------
               excludefirstlast = FALSE,
               includenightcrit = 16,
               def.noc.sleep = 1,
               loglocation= "D:/sleeplog.csv",
               outliers.only = FALSE,
               criterror = 4,
               relyonsleeplog = FALSE,
               sleeplogidnum = TRUE,
               colid=1, 
               coln1=2, 
               do.visual = TRUE,
               nnights = 9,
               #-------------------------------
               # Part 5 parameters:
               #-------------------------------
               # Key functions: Merging physical activity with sleep analyses
               threshold.lig = c(30,40,50),
               threshold.mod = c(100,120),
               threshold.vig = c(400,500),
               excludefirstlast = FALSE,
               boutcriter = 0.8,
               boutcriter.in = 0.9,
               boutcriter.lig = 0.8,
               boutcriter.mvpa = 0.8,
               boutdur.in = c(10,20,30),
               boutdur.lig = c(1,5,10),
               boutdur.mvpa = c(1,5,10),
               timewindow = c("WW"),
               #-----------------------------------
               # Report generation
               #-------------------------------
               do.report=c(2,4,5))
  }
}
\author{
  Vincent T van Hees <v.vanhees@accelting.com>
}
\references{
  \itemize{
    \item van Hees VT, Gorzelniak L, Dean Leon EC, Eder M, Pias M, et al. (2013) Separating
    Movement and Gravity Components in an Acceleration Signal and Implications for the
    Assessment of Human Daily Physical Activity. PLoS ONE 8(4): e61691.
    doi:10.1371/journal.pone.0061691
    \item van Hees VT, Fang Z, Langford J, Assah F, Mohammad A, da Silva IC, Trenell MI, 
    White T, Wareham NJ, Brage S. Auto-calibration of accelerometer data for
    free-living physical activity assessment using local gravity and temperature: 
    an evaluation on four continents. J Appl Physiol (1985). 2014 Aug 7
    \item van Hees VT, Sabia S, et al. (2015) A novel, open access method to
    assess sleep duration using a wrist-worn accelerometer, PLoS ONE, November 2015
  }
}
