% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmncv.R
\name{GGMncv}
\alias{GGMncv}
\title{GGMncv}
\usage{
GGMncv(
  x,
  n,
  penalty = "atan",
  ic = "bic",
  lambda = NULL,
  n_lambda = 50,
  gamma = NULL,
  select = FALSE,
  L0_learn = FALSE,
  refit = FALSE,
  LLA = TRUE,
  initial = "sicm",
  method = "pearson",
  progress = TRUE,
  store = TRUE,
  vip = FALSE,
  vip_iter = 1000,
  ...
)
}
\arguments{
\item{x}{There are 2 options: either a \code{n} by \code{p} data matrix or a
\code{p} by \code{p} correlation matrix.}

\item{n}{Numeric. Sample size.}

\item{penalty}{Character string. Which penalty should be used (defaults to \code{atan}).}

\item{ic}{Character string. Which information criterion should be used (defaults to \code{bic}), give
\code{select = TRUE}. The options include \code{aic}, \code{ebic}
(ebic_gamma defaults to \code{0.5}; see details), \code{ric},
or any generalized information criterion provided in section 5 of
\insertCite{kim2012consistent;textual}{GGMncv}.
The options are \code{gic_1} (i.e., \code{bic}) to \code{gic_7}.}

\item{lambda}{Numeric. Tuning parameter governing the degrees of penalization. Defaults to
\code{NULL} which results in fixing lambda to \code{sqrt(log(p)/n)}.}

\item{n_lambda}{Numeric. The number of regularization/thresholding parameters
(defaults to \code{100}).}

\item{gamma}{Numeric. Hyperparameter for the penalty function. Defaults to \code{0.1}
which is the recommended value for the default penalty (see details).}

\item{select}{Logical. Should lambda be selected with BIC (defaults to \code{FALSE})?}

\item{L0_learn}{Logical. Should lambda be selected based on the non-regularized
precision matrix (defaults to \code{FALSE}; see details).}

\item{refit}{Logical. Should the precision matrix be refitted, given the adjacency matrix
(defaults to \code{FALSE})? When set to \code{TRUE}, this provides the \strong{non-regularized},
maximum likelihood estimate with constraints.}

\item{LLA}{Logical. Should the local linear approximation be used for maximizing the penalized likelihood ?
The default is \code{TRUE} (see details). Setting to \code{FALSE} results in the so-called
one-step approach.}

\item{initial}{Character string. Which initial values should be used for the one-step approach
(i.e., \code{LLA = FALSE}) ? Default is the sample inverse
covariance matrix (\code{sicm}). Options include \code{sicm} and \code{lw}
\insertCite{@Ledoit and Wolf shrinkage estimator; @ledoit2004well}{GGMncv}.}

\item{method}{Character string. Which correlation coefficient should be computed.
One of "pearson" (default), "spearman", or  "polychoric".}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ? Note that
this only applies when \code{select = TRUE}.}

\item{store}{Logical. Should all of the fitted models be saved (defaults to \code{NULL}). Note
this only applies when \code{select = TRUE}. and ignored otherwise
(the one model is saved.)}

\item{vip}{Logical. Should variable inclusion "probabilities" be computed (defaults to \code{FALSE})?}

\item{vip_iter}{Numeric. How many bootstrap sample for computing \code{vip} (defaults to 1000) ? Note
also that only the default lambda is implemented (select is not implemented).}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{ggmncv}, including:

\itemize{
\item \code{Theta} Inverse covariance matrix
\item \code{Sigma} Covariance matrix
\item \code{P} Weighted adjacency matrix
\item \code{adj} Adjacency matrix
\item \code{lambda} Tuning parameter (i.e., sqrt(log(p)/n))
\item \code{fit} glasso fitted model (a list)
}
}
\description{
Estimate Gaussian graphical models with non-convex penalties.
}
\details{
Several of the penalties are (continuous) approximations to the L0 penalty, that is,
best subsets model selection. However, the solution does not require enumerating
all possible models which results in a computationally efficient algorithm.

L0 approximations:

\itemize{

\item Atan: \code{penalty = "atan"} \insertCite{wang2016variable}{GGMncv}. This is currently the default.

\item Seamless L0: \code{penalty = "selo"} \insertCite{dicker2013variable}{GGMncv}.

\item Exponential: \code{penalty = "exp"}  \insertCite{wang2018variable}{GGMncv}

\item Log: \code{penalty = "log"} \insertCite{mazumder2011sparsenet}{GGMncv}.

\item Sica: \code{penalty = "sica"}  \insertCite{lv2009unified}{GGMncv}

}

Additional penalties:

\itemize{

\item SCAD: \code{penalty = "scad"}  \insertCite{fan2001variable}{GGMncv}.

\item MCP: \code{penalty = "mcp"} \insertCite{zhang2010nearly}{GGMncv}.

\item Adaptive lasso \code{penalty = "adapt"}  \insertCite{zou2006adaptive}{GGMncv}

\item Lasso  \code{penalty = "lasso"}  \insertCite{tibshirani1996regression}{GGMncv}

}

\strong{Gamma}

The \code{code} gamma argument corresponds to additional hyperparameter for each penalty.
The defaults are set to the recommended values from the respective papers.

\strong{L0_learn}

\code{L0_learn} is perhaps a misnomer, in that best subsets solution is not computed.
This option corresponds to the following steps, assuming \code{select = TRUE}:

\enumerate{

\item Estimte the graph for a given lambda value

\item Refit the precision matrix, given the contraints from step 1. This results
in the maximum likelihood estimate (non-regularized).

\item Compute BIC for the refitted graph from step 2.

\item After repeating steps 1-3 for lambda value, select the graph according to BIC.

}

Note that this is most useful in datasets that have more nodes than variables
(i.e., low-dimensional).

\strong{LLA}

The local linear approximate is for non-covex penalties is described in
\insertCite{fan2009network}{GGMncv}. This is essentially a weighted (g)lasso.
Note that by default \code{LLA = TRUE}. This can be set to \code{FALSE} when \emph{n} is
much larger than \emph{p} (e.g., this can improve power). This is due to the work
of \insertCite{zou2008one}{GGMncv}, which suggested that, so long as the starting
values are good, then it is possible to use a one-step estimator. In the case of low-dimensional data,
the sample based inverse covariance matrix is used to compute the lambda matrix. This is expected to work well, assuming
that \emph{n} is sufficiently larger than \emph{p}. For high-dimensional data, the initial values for obtaining
the lambda matrix are obtained from glasso.

\strong{Model Selection}

It is common to select lambda. However, in more recent approaches (see references above), lambda is fixed to
\code{sqrt(log(p)/n)}. This has the advantage of being tuning free and this value is expected
to provide competitive performance. It is possible to select lambda by setting \code{select = TRUE}.

\strong{EBIC}

When setting \code{ic = "ebic"}, the additional parameter that determines the additional penalty to BIC is
passed via the \code{...} argument. This must be specificed as \code{ebic_gamma = 1}, with the default set
to \code{0.5}.
}
\examples{
# data
Y <- GGMncv::ptsd[,1:10]

S <- cor(Y)

# fit model
fit <- GGMncv(S, n = nrow(Y))

# plot
qgraph::qgraph(fit$P)
}
\references{
\insertAllCited{}
}
