\name{ghap.hap2tped}
\alias{ghap.hap2tped}

\title{
 Convert haplotype allele counts to PLINK tped
}
\description{
 This function takes a haplotype genotypes matrix (as generated with the \code{\link{ghap.haplotyping}} function) and converts it to PLINK tped format.
}
\usage{
ghap.hap2tped(infile,batchsize = 500, outfile,verbose = TRUE)
}

\arguments{
  \item{infile}{
   The prefix for the \emph{.hapsamples}, \emph{.hapalleles} and \emph{.hapgenotypes} files generated by \code{\link{ghap.haplotyping}}.
  }
  \item{batchsize}{
   A numeric value controlling the number of haplotype alleles to be processed at a time (default = 500).
  }
  \item{outfile}{
   A character value specifying the name used for the .tped, .tfam and .tref output files.
  }
  \item{verbose}{
   A logical value specfying whether log messages should be printed (default = TRUE).
  }
}
\details{
 The returned file mimics a standard PLINK (Purcell et al., 2007; Chang et al., 2015) tped file, where haplotype allele counts 0, 1 and 2 are recoded as NN, NH and HH genotypes (N = NULL and H = haplotype allele), as if haplotypes were bi-alelic markers. This codification is acceptable for any given analysis relying on SNP genotype counts, as long as the user specifies that the analysis should be done using the H allele as reference for counts. You can specify reference alleles using the .tref file in PLINK with the \emph{reference-allele} command. This is desired for very large datasets, as softwares such as PLINK and GCTA (Yang et al., 2011) have faster implementations for regression, principal components and kinship matrix analyses. The name for each pseudo-marker is composed by a concatenation (separated by "_") of block name, start, end, and haplotype allele identity. Pseudo-marker positions are computed as (start+end)/2.
}
\author{
Yuri Tani Utsunomiya <ytutsunomiya@gmail.com>

Marco Milanesi <marco.milanesi.mm@gmail.com>
}
\references{
C. C. Chang et al. Second-generation PLINK: rising to the challenge of larger and richer datasets. Gigascience. 2015. 4, 7.

S. Purcell et al. PLINK: a tool set for whole-genome association and population-based linkage analyses. Am. J. Hum. Genet. 2007. 81, 559-575.

J. Yang et al. GCTA: A tool for genome-wide complex trait analysis. Am. J. Hum. Genet. 2011. 88, 76-82.
}
\examples{

# #### DO NOT RUN IF NOT NECESSARY ###
# 
# # Copy the example data in the current working directory
# ghap.makefile()
# 
# # Load data
# phase <- ghap.loadphase("human.samples", "human.markers", "human.phase")
# 
# # Subset data - markers with maf > 0.05
# maf <- ghap.maf(phase, ncores = 2)
# markers <- phase$marker[maf > 0.05]
# phase <- ghap.subsetphase(phase, unique(phase$id), markers)
# 
# # Generate blocks of 5 markers sliding 5 markers at a time
# blocks.mkr <- ghap.blockgen(phase, windowsize = 5, slide = 5, unit = "marker")
#
# # Generate matrix of haplotype genotypes
# ghap.haplotyping(phase, blocks.mkr, batchsize = 100, ncores = 2, outfile = "human")
#
# # Load haplotype genotypes
# haplo <- ghap.loadhaplo("human.hapsamples", "human.hapalleles", "human.hapgenotypes")
#
#
# ### RUN ###
#
# # Subset common haplotypes
# hapstats <- ghap.hapstats(haplo, ncores = 2)
# common <- hapstats$TYPE \%in\% c("REGULAR","MAJOR") &
#  hapstats$FREQ > 0.05 &
#  hapstats$FREQ < 0.95
# haplo <- ghap.subsethaplo(haplo,unique(haplo$id),common)
# 
# # Output GHap.haplo object
# ghap.outhaplo(haplo = haplo, outfile = "humansub")
# 
# # Convert to tped
# ghap.hap2tped(infile = "humansub", outfile = "humansub")

}

