% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_cosinor.R
\name{simulate_cosinor}
\alias{simulate_cosinor}
\title{Simulate data from a cosinor model}
\usage{
simulate_cosinor(
  n,
  mesor,
  amp,
  acro,
  period = 24,
  n_components,
  beta.group = FALSE,
  beta.mesor,
  beta.amp,
  beta.acro,
  n_period = 1,
  family = c("gaussian", "poisson", "binomial", "gamma"),
  ...
)
}
\arguments{
\item{n}{The sample size. An \code{integer} greater than 0.}

\item{mesor}{A \code{numeric}. The MESOR (midline estimating statistic of
rhythm) for \code{group = 0}. The MESOR is independent of the cosinor
components, so only one value is allowed even if there are multiple
components in the data being simulated.}

\item{amp}{A \code{numeric}. The amplitude value (for \code{group = 0} if
grouped data are being simulated (\code{beta.group = TRUE})). If simulating
data with multiple components, specify a vector with values for each
component. E.g: \code{amp = c(5, 10)}.}

\item{acro}{A \code{numeric}. The acrophase value in radians
(for \code{group = 0} if grouped data are being simulated
(\code{beta.group = TRUE})). If simulating data with multiple components,
specify a vector with values for each component. E.g: \code{acr = c(0, pi)}
for two components.}

\item{period}{The period of the rhythm data (for \code{group = 0} if
grouped data are being simulated (\code{beta.group = TRUE})).
If simulating data with multiple components, specify a vector with values
for each component. E.g: \code{period = c(12, 6)} for two components.}

\item{n_components}{The number of components in the model.
This must match the length of the inputs for \code{amp} and \code{acro}.}

\item{beta.group}{A \code{logical}. If \code{TRUE} a second group of data
will be simulated and included in the returned data set. If \code{FALSE},
\code{beta.acro}, \code{beta.mesor}, and \code{beta.amp} arguments will be
ignored.}

\item{beta.mesor}{A \code{numeric}. The MESOR value term for \code{group = 1}}

\item{beta.amp}{A \code{numeric}. The amplitude value for \code{group = 1}.
If simulating data with multiple components, specify a vector with values for
each component. E.g: \code{amp = c(2, 8)}.}

\item{beta.acro}{A \code{numeric}. The acrophase value in radians
(for \code{group = 1}. If simulating data with multiple components,
specify a vector with values for each component. E.g: \code{acr = c(2, 5)}
for two components.}

\item{n_period}{A \code{numeric}. The number of cycles of the rhythm to be
simulated.}

\item{family}{A \code{character}. The family (see \code{?family}) of the
simulated dataset. Can handle values in \code{c("poisson", "binomial",
"gamma", "gaussian")}.}

\item{...}{Extra arguments, including \code{alpha} that controls the
\code{shape} argument when sampling from a gamma distribution
(when \code{family = "gamma"}; default is 1), and \code{sd}
(standard deviation) which is used when sampling from a normal distribution
(when \code{family = "gaussian"}; default is 1). To specify these parameters
for the beta (treatment) group, use \code{beta.alpha} and \code{beta.sd}}
}
\value{
Returns simulated data in a \code{data.frame}.
}
\description{
This function simulates data from a cosinor model with a single covariate,
where the time scale is month, and optionally
allows for single covariate effects on the mean,
amplitude, and acrophase.
}
\examples{
simulate_cosinor(
  n = 100,
  mesor = 1,
  amp = 1,
  acro = 1,
  period = 24,
  family = "gaussian"
)
}
