# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Family of models for Discrete Choice
#' @description Discrete choice model: Requires data in long form.
#' For each individual (or decision maker), there are multiple observations (rows),
#' one for each of the alternatives the individual could have chosen.
#' We call the group of observations for an individual a “case”.
#' Each case represents a single statistical observation although it comprises
#' multiple observations.
#' @title Discrete_CM
#' @rdname Discrete_CM
#' @name Discrete_CM
#' @param formula a symbolic description of the model to be fit. An expression of the form y ~ predictors is interpreted as a specification that the response y is modelled by a linear predictor specified symbolically by model. A particularity for the formula is that for the case-specific variables, the user can define a specific effect for a category.
#' @param case_id a string with the name of the column that identifies each case.
#' @param alternatives a string with the name of the column that identifies the vector of alternatives the individual could have chosen.
#' @param reference a string indicating the reference category
#' @param alternative_specific a character vector with the name of the explanatory variables that are different for each case, these are the alternative specific variables. By default, the case specific variables are the explanatory variables that are not identify in here, but that are part of the formula.
#' @param data a dataframe (in a long format) object in R, with the dependent variable as factor.
#' @param cdf
#' \describe{
#' \item{\code{cdf}:}{a string indicating the F cdf, options are: logistic, normal, cauchy, student (any df), noncentralt, gompertz, gumbel and laplace.}
#' \item{\code{df}:}{an integer with the degrees of freedom of the 'cdf'}
#' \item{\code{mu}:}{an integer with the mu parameter of the 'cdf'}
#' }
#' @param intercept if "conditional" then the design will be equivalent to the conditional logit model
#' @param normalization the quantile to use for the normalization of the estimated coefficients where the logistic distribution is used as the base cumulative distribution function.
#' @param control
#' \describe{
#' \item{\code{maxit}:}{the maximum number of iterations for the Fisher scoring algorithm.}
#' \item{\code{epsilon}:}{a double with to fix the epsilon value}
#' \item{\code{beta_init}:}{an appropiate sized vector for the initial iteration of the algorithm}
#' }
#' @examples
#' library(GLMcat)
#' data(TravelChoice)
#' Discrete_CM(formula = choice ~ hinc + gc + invt,
#' case_id = "indv",alternatives = "mode", reference = "air",
#' data = TravelChoice,  alternative_specific = c("gc", "invt"),
#' cdf = "logistic")
#' @note For these models it is not allowed to exclude the intercept.
#' @export
Discrete_CM <- function(formula, case_id, alternatives, reference, alternative_specific, data, cdf, intercept, normalization, control) {
    .Call(`_GLMcat_Discrete_CM`, formula, case_id, alternatives, reference, alternative_specific, data, cdf, intercept, normalization, control)
}

#' Families of models for categorical responses
#' @description Families of models for categorical responses (reference, adjacent, sequential, and cumulative ratio)
#' @title GLMcat
#' @rdname GLMcat
#' @name GLMcat
#' @param formula a symbolic description of the model to be fit. An expression of the form y ~ predictors is interpreted as a specification that the response y is modelled by a linear predictor specified symbolically by model.
#' @param ratio a string indicating the F cdf, options are: reference, adjacent, cumulative and sequential. Default value is reference.
#' @param cdf
#' \describe{
#' \item{\code{cdf}:}{a string indicating the F cdf, options are: logistic, normal, cauchy, student (any df), noncentralt, gompertz, gumbel and laplace.}
#' \item{\code{df}:}{an integer with the degrees of freedom of the 'cdf'}
#' \item{\code{mu}:}{an integer with the mu parameter of the 'cdf'}
#' }
#' @param categories_order a character vector indicating the incremental order of the categories: c("a", "b", "c"); a<b<c. Alphabetical order is assumed by default. Order is relevant for adjacent, cumulative and sequential ratio.
#' @param ref_category a string indicating the reference category. Proper option for models with reference ratio.
#' @param parallel a character vector indicating the name of the variables with a parallel effect. If variable is categorical, specify the name and the level of the variable as a string "namelevel".
#' @param data a dataframe object in R, with the dependent variable as factor.
#' @param threshold restriction to impose on the thresholds, options are: standard, equidistant or symmetric (Valid only for the cumulative ratio).
#' @param control
#' \describe{
#' \item{\code{maxit}:}{the maximum number of iterations for the Fisher scoring algorithm.}
#' \item{\code{epsilon}:}{a double to change update the convergence criterion of GLMcat models.}
#' \item{\code{beta_init}:}{an appropiate sized vector for the initial iteration of the algorithm.}
#' }
#' @param normalization the quantile to use for the normalization of the estimated coefficients where the logistic distribution is used as the base cumulative distribution function.
#' @export
#' @examples
#' data(DisturbedDreams)
#' ref_log_com <- GLMcat(formula = Level ~ Age, data = DisturbedDreams,
#'     ref_category = "Very.severe",
#'     cdf = "logistic", ratio = "reference")
GLMcat <- function(formula, data, ratio, cdf, parallel, categories_order, ref_category, threshold, control, normalization) {
    .Call(`_GLMcat_GLMcat`, formula, data, ratio, cdf, parallel, categories_order, ref_category, threshold, control, normalization)
}

#' Prediction based on GLMcat models
#' @description GLMcat model predictions
#' @param model_object a GLMcat model
#' @param data a data frame with the predictor variables used in the GLMcat model.
#' @param type The type of prediction to obtain. \code{"prob"} gives probabilities,
#' \code{"cum.prob"} gives cumulative probabilities and \code{"linear.predict"} gives
#' the linear predictor.
#' @rdname predict
#' @name predict_glmcat
#' @title predict.glmcat
#' @export
#' @examples
#' data(DisturbedDreams)
#' mod1 <- GLMcat(formula = Level ~ Age,
#' data = DisturbedDreams, cdf = "logistic")
#' predict_glmcat(mod1, data = DisturbedDreams[1:5, ], type = "prob")
predict_glmcat <- function(model_object, data, type) {
    .Call(`_GLMcat_predict_glmcat`, model_object, data, type)
}

