% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mia.R
\name{predict.mia}
\alias{predict.mia}
\title{Predict GMDH MIA object}
\usage{
\method{predict}{mia}(object, newdata, ...)
}
\arguments{
\item{object}{an object of class 'mia'}

\item{newdata}{matrix containing dependent variables in the model, wich the predictions are calculated.}

\item{...}{other undocumented arguments}
}
\value{
A matrix with predictions.
}
\description{
Calculates GMDH MIA model predictions for new data.
}
\examples{
set.seed(123)
x <- matrix(data = c(rnorm(1000)), ncol = 5, nrow = 200)
colnames(x) <- c("a", "b", "c", "d", "e")
y <- matrix(data = c(10 + x[, "a"] * x[, "e"]^3), ncol = 1)
colnames(y) <- "y"
x.test <- x[1:10, ]
y.test <- y[1:10]
x <- x[-c(1:10), ]
y <- y[-c(1:10)]

mod <- gmdh.mia(X = x, y = y, prune = 5)
pred <- predict(mod, x.test)
summary(sqrt((pred - y.test)^2))

}
