% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource.R
\name{resource}
\alias{resource}
\title{Resource model}
\usage{
resource(RESOURCES = NULL, LAND = NULL, PARAS = NULL,
  model = "IBM")
}
\arguments{
\item{RESOURCES}{The resources array produced by the resource function within GMSE}

\item{LAND}{The landscape array on which interactions between resources and agents occur}

\item{PARAS}{The vector of parameters that hold global and dynamic parameter values used by GMSE}

\item{model}{The type of model being applied (Currently only individual-based
-- i.e., 'agent-based' -- models are allowed)}
}
\value{
The resource function outputs an R list that includes three separate arrays, including (1) an new RESOURCES array, (2) a new LAND array, (3) a new PARAS array, each of which might be affected by the user function. The new arrays can then be read back into the broader GMSE function, thereby affecting the input into the observation, management, and user models.
}
\description{
A population model of resource (including population) dynamics for 
a single time step.
}
\examples{
\dontrun{
RESOURCE_NEW <- resource(RESOURCES = RESOURCES, LAND = LANDSCAPE_r, 
PARAS = paras, model = "IBM");
}
}
