% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ss.bin.trt.int.oc.df.r
\name{get.ss.bin.trt.int.oc.df}
\alias{get.ss.bin.trt.int.oc.df}
\title{Get single sample binary interim treatment OC data.frame}
\usage{
get.ss.bin.trt.int.oc.df(
  a.trt = 1,
  b.trt = 1,
  Delta.tv = 0.35,
  Delta.lrv = 0.2,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  interim.n.t = c(10),
  final.n.t = 100,
  x.ng = NULL,
  x.go = NULL,
  go.thresh = 0.8,
  ng.thresh = 0.8
)
}
\arguments{
\item{a.trt}{prior alpha parameter}

\item{b.trt}{prior beta parameter}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{interim.n.t}{number of trials at interim}

\item{final.n.t}{number of trials at final}

\item{x.ng}{responses needed for no-go; leave null for standard rule}

\item{x.go}{responses needed for go; leave null for standard rule}

\item{go.thresh}{go threshold for predictive probability}

\item{ng.thresh}{no-go threshold for predictive probability}
}
\value{
A data.frame is returned
}
\description{
Get single sample binary interim treatment OC data.frame
}
\examples{
\donttest{
my.ss.bin.trt.int.oc.df <- get.ss.bin.trt.int.oc.df()
my.ss.bin.trt.int.oc.df[[1]]
my.ss.bin.trt.int.oc.df[[2]]
}
}
