% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.ts.ng.studyend.GNG.hm.df.r
\name{return.ts.ng.studyend.GNG.hm.df}
\alias{return.ts.ng.studyend.GNG.hm.df}
\title{Return two-sample normal-gamma study end GNG heatmap data.frame}
\usage{
return.ts.ng.studyend.GNG.hm.df(
  mu.0.c = 0,
  alpha.0.c = 0.25,
  beta.0.c = 1,
  n.0.c = 1,
  mu.0.t = 0,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  n.0.t = 1,
  xbar.c.low = -1,
  xbar.c.high = 1,
  s.c = 4,
  n.c = 40,
  s.t = 4,
  n.t = 40,
  npoints = 15,
  Delta.lrv = 1,
  Delta.tv = 1.5,
  tau.ng = 0.65,
  tau.lrv = 0.8,
  tau.tv = 0.1,
  n.MC = 1000,
  x_ng = NULL,
  x_go = NULL
)
}
\arguments{
\item{mu.0.c}{prior mean for control group}

\item{alpha.0.c}{prior alpha parameter for control group}

\item{beta.0.c}{prior beta parameter for control group}

\item{n.0.c}{prior effective sample size parameter for control group}

\item{mu.0.t}{prior mean for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{n.0.t}{prior effective sample size parameter for treatment group}

\item{xbar.c.low}{lower bound for control group sample mean grid}

\item{xbar.c.high}{upper bound for control group sample mean grid}

\item{s.c}{control standard deviation assumed}

\item{n.c}{control sample size}

\item{s.t}{treatment standard deviation assumed}

\item{n.t}{treatment sample size}

\item{npoints}{number of points to use in simulation}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{n.MC}{n for MC sampling}

\item{x_ng}{xbar needed for no-go; leave null for standard rule}

\item{x_go}{xbar needed for go; leave null for standard rule}
}
\value{
A data.frame is returned
}
\description{
Return two-sample normal-gamma study end GNG heatmap data.frame
}
\examples{
\donttest{
my.ts.ng.studyend.GNG.hm.df <- return.ts.ng.studyend.GNG.hm.df()
head(my.ts.ng.studyend.GNG.hm.df)
}
}
\author{
Greg Cicconetti
}
