% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gotermlevelcc.R
\name{GOTermCCOnLevel}
\alias{GOTermCCOnLevel}
\title{GO cellular component (CC) terms level getter}
\usage{
GOTermCCOnLevel(goterm)
}
\arguments{
\item{goterm}{An object of class character. A character string of GO cellular component (CC) terms.
The object can be a GO-term or a vector of GO-terms}
}
\value{
A two-column matrix of the GO-terms and the level they map to
}
\description{
Get the level of a GO cellular component (CC) term based on the directed acyclic graph (DAG)
}
\note{
The Gene Ontology (GO) cellular component (CC) tree was built using the root node "GO:0005575"
}
\examples{

# Cellular component GO terms
goterms <- c("GO:0005634", "GO:0005737", "GO:0016020", "GO:0005743", "GO:0005739",
"GO:0005759", "GO:0005829")

GOTermCCOnLevel(goterms)

GOTermCCOnLevel("GO:0005730")


}
