% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gotermlevel.R
\name{Level2GOTermBP}
\alias{Level2GOTermBP}
\title{GO biological process (BP) terms on a level}
\usage{
Level2GOTermBP(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{The organism of interest. If NULL the results will be from the general GO BP tree}
}
\value{
A list of GO-terms from the level
}
\description{
Gets all the biological process (BP) GO-terms on a GO-level.
             The supported organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse",
             "Danio rerio / Zebrafish", "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress",
             "Saccharomyces cerevisiae / Yeast", "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\note{
The Gene Ontology (GO) biological process (BP) tree was built using the root node GO:0001850
}
\examples{
# Gene association GO-terms for organism Yeast on level 6
Level2GOTermBP(level = 6, organism = "Yeast")

# Gene association GO-terms for organism Fruit fly on level 2
Level2GOTermBP(level = 2, organism = "Fruit fly")

}
