% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaSPUtils.R
\name{gp}
\alias{gp}
\title{Construct the \code{S4} object \linkS4class{gp}}
\usage{
gp(
  formula = ~1,
  output,
  input,
  param,
  smooth.est = FALSE,
  cov.model = list(family = "CH", form = "isotropic"),
  dtype = "Euclidean"
)
}
\arguments{
\item{formula}{an object of \code{formula} class that specifies regressors; see \code{\link[stats]{formula}} for details.}

\item{output}{a numerical vector including observations or outputs in a GaSP}

\item{input}{a matrix including inputs in a GaSP}

\item{param}{a list including values for regression parameters, covariance parameters, 
and nugget variance parameter.
The specification of \strong{param} should depend on the covariance model. 
\itemize{
\item{The regression parameters are denoted by \strong{coeff}. Default value is \eqn{\mathbf{0}}.}
\item{The marginal variance or partial sill is denoted by \strong{sig2}. Default value is 1.}
\item{The nugget variance parameter is denoted by \strong{nugget} for all covariance models. 
Default value is 0.}
\item{For the Confluent Hypergeometric class, \strong{range} is used to denote the range parameter \eqn{\beta}. 
\strong{tail} is used to denote the tail decay parameter \eqn{\alpha}. \strong{nu} is used to denote the 
smoothness parameter \eqn{\nu}.}
\item{For the generalized Cauchy class, \strong{range} is used to denote the range parameter \eqn{\phi}. 
\strong{tail} is used to denote the tail decay parameter \eqn{\alpha}. \strong{nu} is used to denote the 
smoothness parameter \eqn{\nu}.}
\item{For the Matérn class, \strong{range} is used to denote the range parameter \eqn{\phi}. 
\strong{nu} is used to denote the smoothness parameter \eqn{\nu}. When \eqn{\nu=0.5}, the 
Matérn class corresponds to the exponential covariance.}  
\item{For the powered-exponential class, \strong{range} is used to denote the range parameter \eqn{\phi}.
\strong{nu} is used to denote the smoothness parameter. When \eqn{\nu=2}, the powered-exponential class
corresponds to the Gaussian covariance.}
}}

\item{smooth.est}{a logical value indicating whether smoothness parameter will be estimated.}

\item{cov.model}{a list of two strings: \strong{family}, \strong{form}, where \strong{family} indicates the family of covariance functions 
including the Confluent Hypergeometric class, the Matérn class, the Cauchy class, the powered-exponential class. \strong{form} indicates the 
specific form of covariance structures including the isotropic form, tensor form, automatic relevance determination form. 
\describe{
\item{\strong{family}}{
\describe{
\item{CH}{The Confluent Hypergeometric correlation function is given by 
\deqn{C(h) = \frac{\Gamma(\nu+\alpha)}{\Gamma(\nu)} 
\mathcal{U}\left(\alpha, 1-\nu, \left(\frac{h}{\beta}\right)^2\right),}
where \eqn{\alpha} is the tail decay parameter. \eqn{\beta} is the range parameter.
\eqn{\nu} is the smoothness parameter. \eqn{\mathcal{U}(\cdot)} is the confluent hypergeometric
function of the second kind. For details about this covariance, 
see Ma and Bhadra (2019) at \url{https://arxiv.org/abs/1911.05865}.  
}
\item{cauchy}{The generalized Cauchy covariance is given by
\deqn{C(h) = \left\{ 1 + \left( \frac{h}{\phi} \right)^{\nu}  
            \right\}^{-\alpha/\nu},}
where \eqn{\phi} is the range parameter. \eqn{\alpha} is the tail decay parameter.
\eqn{\nu} is the smoothness parameter with default value at 2.
}

\item{matern}{The Matérn correlation function is given by
\deqn{C(h)=\frac{2^{1-\nu}}{\Gamma(\nu)} \left( \frac{h}{\phi} \right)^{\nu} 
\mathcal{K}_{\nu}\left( \frac{h}{\phi} \right),}
where \eqn{\phi} is the range parameter. \eqn{\nu} is the smoothness parameter. 
\eqn{\mathcal{K}_{\nu}(\cdot)} is the modified Bessel function of the second kind of order \eqn{\nu}.
}
\item{exp}{The exponential correlation function is given by 
\deqn{C(h)=\exp(-h/\phi),}
where \eqn{\phi} is the range parameter. This is the Matérn correlation with \eqn{\nu=0.5}.
}
\item{matern_3_2}{The Matérn correlation with \eqn{\nu=1.5}.}
\item{matern_5_2}{The Matérn correlation with \eqn{\nu=2.5}.}


\item{powexp}{The powered-exponential correlation function is given by
               \deqn{C(h)=\exp\left\{-\left(\frac{h}{\phi}\right)^{\nu}\right\},}
where \eqn{\phi} is the range parameter. \eqn{\nu} is the smoothness parameter.
}
\item{gauss}{The Gaussian correlation function is given by 
\deqn{C(h)=\exp\left(-\frac{h^2}{\phi^2}\right),}
where \eqn{\phi} is the range parameter.
 }
}
}

\item{\strong{form}}{
\describe{
 \item{isotropic}{This indicates the isotropic form of covariance functions. That is,
 \deqn{C(\mathbf{h}) = C^0(\|\mathbf{h}\|; \boldsymbol \theta),} where \eqn{\| \mathbf{h}\|} denotes the 
Euclidean distance or the great circle distance for data on sphere. \eqn{C^0(\cdot)} denotes 
any isotropic covariance family specified in \strong{family}.}
 \item{tensor}{This indicates the tensor product of correlation functions. That is, 
\deqn{ C(\mathbf{h}) = \prod_{i=1}^d C^0(|h_i|; \boldsymbol \theta_i),}
where \eqn{d} is the dimension of input space. \eqn{h_i} is the distance along the \eqn{i}th input dimension. This type of covariance structure has been often used in Gaussian process emulation for computer experiments.
}
 \item{ARD}{This indicates the automatic relevance determination form. That is, 
\deqn{C(\mathbf{h}) = C^0\left(\sqrt{\sum_{i=1}^d\frac{h_i^2}{\phi^2_i}}; \boldsymbol \theta \right),}
where \eqn{\phi_i} denotes the range parameter along the \eqn{i}th input dimension.}
 }
}

}}

\item{dtype}{a string indicating the type of distance:
\describe{
\item{Euclidean}{Euclidean distance is used. This is the default choice.}
\item{GCD}{Great circle distance is used for data on sphere.}
}}
}
\value{
an \code{S4} object of \linkS4class{gp} class
}
\description{
This function constructs the \code{S4} object \linkS4class{gp}  that is used for Gaussian process 
model fitting and prediction.
}
\examples{
 
code = function(x){
y = (sin(pi*x/5) + 0.2*cos(4*pi*x/5))*(x<=9.6) + (x/10-1)*(x>9.6) 
return(y)
}
n=100
input = seq(0, 20, length=n)
XX = seq(0, 20, length=99)
Ztrue = code(input)
set.seed(1234)
output = Ztrue + rnorm(length(Ztrue), sd=0.1)
obj = gp(formula=~1, output, input, 
        param=list(range=4, nugget=0.1,nu=2.5),
        smooth.est=FALSE,
        cov.model=list(family="matern", form="isotropic"))

}
\seealso{
\link{GPBayes-package}, \code{\link{GaSP}}
}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
