% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{powexp}
\alias{powexp}
\title{The powered-exponential correlation function}
\usage{
powexp(d, range, nu)
}
\arguments{
\item{d}{a matrix of distances}

\item{range}{a numerical value containing the range parameter}

\item{nu}{a numerical value containing the smoothness parameter}
}
\value{
a numerical matrix
}
\description{
This function computes the powered-exponential correlation function given
a distance matrix. The powered-exponential correlation function is given by
               \deqn{C(h)=\exp\left\{-\left(\frac{h}{\phi}\right)^{\nu}\right\},}
where \eqn{\phi} is the range parameter. \eqn{\nu} is the smoothness parameter.
The case \eqn{\nu=2} corresponds to the well-known Gaussian correlation.
}
\seealso{
\code{\link{kernel}}
}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
