% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_w_corr.R
\name{compute_w_corr}
\alias{compute_w_corr}
\title{Compute Weighted Correlation}
\usage{
compute_w_corr(data, weights)
}
\arguments{
\item{data}{A data.table of observational data with the following columns:
\itemize{
\item Column 1: Outcome (Y)
\item Column 2: Exposure or treatment (w)
\item Column 3~m: Confounders (C)
}}

\item{weights}{A vector of weights for each observation data.}
}
\value{
A vector of covariate balance.
}
\description{
Computes weighted correlation of the observational data based on weights
achieved by Gaussian Process.
}
\examples{

set.seed(124)
mydata <- generate_synthetic_data(sample_size = 200)
data.table::setDT(mydata)
weights <- runif(nrow(mydata))
compute_w_corr(mydata, weights)

}
