% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConvergence.R
\name{plotConvergence}
\alias{plotConvergence}
\title{plotConvergence}
\usage{
plotConvergence(nVar, outL, plotType = "exp", xlim = NULL,
  ylim = NULL, lastIter = NULL, dt = NULL, expList = NULL,
  legend = FALSE)
}
\arguments{
\item{nVar}{Model dimension}

\item{outL}{An input list issued from the FDLyapu algorithm updated at each call, with
outL$t the time vector,
outL$LyapExp the mean Lyapunov exponents 
outL$LyapExpLoc the local Lyapunov exponents,
outL$DkyLoc the mean Kaplan-Yorke dimension.
outL$DkyLoc the local Kaplan-Yorke dimension.}

\item{plotType}{If equals to "exp" the Lyapunov exponents are plotted. Otherwise the Kaplan-Yorke dimension is plotted}

\item{xlim}{The limits used for the x-axis. If NULL it is automatically adjusted to the minimum and maximum data values}

\item{ylim}{The limits used for the u-axis. If NULL it is automatically adjusted to the minimum and maximum data values}

\item{lastIter}{If not NULL indicates the last iterations used for the plot.}

\item{dt}{Integration time step}

\item{expList}{Indicates which exponents have to be plotted. If NULL all are plotted otherwise must be a vector of booleans}

\item{legend}{Indicates if the legend has to appear (TRUE) or not (FALSE)}
}
\description{
Plots the evolution of the standard deviations of either the Lyapunov exponents or the Kaplan-Yorke dimension
}
