% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regSeries.R
\name{regSeries}
\alias{regSeries}
\title{regSeries : Estimate regressors time series}
\usage{
regSeries(nVar, dMax, series, pReg = NULL)
}
\arguments{
\item{nVar}{The model dimension expected. This parameter will be
deduced from the input data (\code{series}) if \code{series} is
a matrix. If \code{series} is a vector, the expected dimension nVar
should be provided.}

\item{dMax}{Maximum degree of the polynomial functions allowed
in the model (see \code{poLabs}).}

\item{series}{A matrix containing the original time series from which
the regressors ones are built. One time series by column}

\item{pReg}{A matrix filled, for each column, with powers of time series
used to create}
}
\value{
rpFull A matrix of time series. Each column correspond to one
regressor such as \eqn{X_1^2 X_3 X_4}
}
\description{
Creates series by multiplying given time series among them.
}
\examples{
data(sprottK)
sprottK <- as.matrix(sprottK)
dMax <- 2
nVar <- dim(sprottK)[2]

#Example 1
polySeries2 <- regSeries(nVar, dMax, sprottK)

#Example 2
p <- c(1,3,1)
polySeries2 <- regSeries(nVar, dMax, sprottK, pReg=p)

}
\author{
Sylvain Mangiarotti
}

