% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpTest.R
\name{gpTest}
\alias{gpTest}
\title{Performing Gaussian process test}
\usage{
gpTest(x, y, v, nullModelKernelTypes = c("white", "fixedvariance"),
  modelKernelTypes = c("rbf", "white", "fixedvariance"), y_fitted = FALSE)
}
\arguments{
\item{x}{One-column matrix which contains the input
values, i.e., time points for GP models.
The values given in this vector are used in GP model, so if any
transformation is needed, remember to transform them now.}

\item{y}{One-column matrix which contains the observed
values at the corresponding time points given in \code{x} vector.}

\item{v}{One-column matrix which contains the fixed
variances at the corresponding time points given in \code{x} vector,
with the corresponding observations given in \code{y} vector.}

\item{nullModelKernelTypes}{Character vector which contains the type of
the kernels which will be used in the null, i.e.,
time-independent GP model. Default is c("white","fixedvariance").}

\item{modelKernelTypes}{Character vector which contains the type of
the kernels which will be used in the time-dependent 
GP model. Default is c("rbf","white","fixedvariance").
Kernel types: \code{'rbf'}, \code{'white'}, \code{'fixedvariance'}.
Note that the lower bound for the length scale parameter of rbf kernel
is set to the minimum distance between consecutive time points in order
to mitigate potential overfitting problems.}

\item{y_fitted}{Logical variable indicating whether the fitted y values
at the observed time points will be given or not. Default is set to FALSE.}
}
\value{
Return list which contains logged Bayes factors (logBF) and the fitted
GP models (nullModel & model) with the specified kernel structures. If y_fitted 
is set to TRUE, fitted y values of the model are returned in y_fitted as
the list element.
}
\description{
Function for fitting time-dependent and time-independent GP models
and computing the Bayes factors.
}
\examples{
x=as.matrix(seq(1,10))
y=as.matrix(sin(x))
v=as.matrix(runif(10,0,0.5))
nullModelKernelTypes=c("white","fixedvariance")
modelKernelTypes=c("rbf","white","fixedvariance")
test_result=gpTest(x,y,v,nullModelKernelTypes,modelKernelTypes,y_fitted=TRUE)
null_model=test_result$nullModel
model=test_result$model
logBF=test_result$logBF
y_fitted=test_result$y_fitted

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{Bayes}
\keyword{factor}
\keyword{model,}

