% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitseq_fitGPs.R
\name{bitseq_fitGPs}
\alias{bitseq_fitGPs}
\title{Fitting GP models for the BitSeq example}
\usage{
bitseq_fitGPs(gpData, fileName_logBF = NULL, fileName_ModelParams = NULL,
  fileName_NullModelParams = NULL)
}
\arguments{
\item{gpData}{for example, output from \code{\link{bitseq_rnaSeqData}}.}

\item{fileName_logBF}{name of the file which contains log Bayes factors.}

\item{fileName_ModelParams}{name of the file which contains model parameters.}

\item{fileName_NullModelParams}{name of the file which contains null model parameters.}
}
\value{
List of results
}
\description{
Function for fitting two GP models and computing Bayes factors, i.e., the ratio of the maximum marginal
likelihood estimates of the two GP models, where the models are:
\itemize{
\item null model: GP with only white noise covariance matrix
\item alternative model: GP with squared exponential and white noise covariance matrices
}
Optionally, log Bayes factors and the parameter estimates can be written to output files whose names
are specified with fileName_logBF,
fileName_ModelParams, and fileName_NullModelParams.
}
\examples{
\dontrun{
RNAseqDATA
gpData=RNAseqDATA$reltr
GPfits=bitseq_fitGPs(gpData)
}

}
\seealso{
\code{\link{bitseq_rnaSeqData}}
}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{GP}
