% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alex.boxplots.R
\name{alex.boxplots}
\alias{alex.boxplots}
\title{Prepare Box Plots of Expression Data by Lesion Groups}
\usage{
alex.boxplots(out.dir, alex.data, alex.kw.results, q, gene.annotation)
}
\arguments{
\item{out.dir}{Path to the folder where the boxplots of selected genes based on the specified q value of the KW results table will be added.}

\item{alex.data}{Output of the alex.prep.lsn.expr function. It's a list of three data tables that include "row.mtch", "alex.expr" with expression data, "alex.lsn" with lesion data. Rows of alex.expr, and "alex.lsn" matrices are ordered by gene ensembl IDs and the columns are ordered by patient ID.}

\item{alex.kw.results}{ALEX Kruskal-Wallis test results (output of the KW.hit.express function).}

\item{q}{minimum q value for a gene to be included in output PDF file of box plots.}

\item{gene.annotation}{Gene annotation data either provided by the user or retrieved from ensembl BioMart database using get.ensembl.annotation function included in the GRIN2.0 library. Data.frame should has four columns: "gene" which is the ensembl ID of annotated genes, "chrom" which is the chromosome on which the gene is located, "loc.start" which is the gene start position, and "loc.end" the gene end position.}
}
\value{
Function return a PDF file with box plots for expression data by lesion groups for selected number of genes based on a specified q-value of the kruskal-wallis test results (one gene per page).
}
\description{
Function return box plots for expression data by lesion groups for selected number of genes based on a specified q-value of the kruskal-wallis test results.
}
\examples{
data(expr.data)
data(lesion.data)
data(hg19.gene.annotation)

# prepare expression, lesion data and return the set of genes with both types of data available
# ordered by gene IDs in rows and patient IDs in columns:
alex.data=alex.prep.lsn.expr(expr.data, lesion.data,
                             hg19.gene.annotation, min.expr=5, min.pts.lsn=5)

# run KW test for association between lesion groups and expression level of the same gene:
alex.kw.results=KW.hit.express(alex.data, hg19.gene.annotation, min.grp.size=5)

# return boxplots for a list of top significant genes to a pre-specified folder using 'out.dir':
dir.create(resultsFolder <- file.path(tempdir(), "temp.out"))

boxplots=alex.boxplots(out.dir=resultsFolder,
                       alex.data, alex.kw.results,
                       1e-15, hg19.gene.annotation)

unlink(resultsFolder, recursive = TRUE)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023) Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=alex.prep.lsn.expr]{alex.prep.lsn.expr()}}, \code{\link[=KW.hit.express]{KW.hit.express()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
