% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yassifyPathways.R
\name{yassifyPathways}
\alias{yassifyPathways}
\title{yassifyPathways}
\usage{
yassifyPathways(
  pathways,
  n = NULL,
  url_map_list = list(),
  url_map_by_words_list = list(),
  min_decimal = 5e-04,
  quiet = TRUE,
  table_row_colors = c(`1` = "#EEF", `2` = "#FFD"),
  ...
)
}
\arguments{
\item{pathways}{A data.frame containing pathways data.}

\item{n}{(optional) The number of rows that the user wishes to display. This defaults to the total number of rows.}

\item{url_map_list}{(optional) A list of vectors containing unique IDs and their corresponding URLs as name:value pairs. In the
enclosing list, the element names are the names of the columns in the data.frame containing the fields needing to be
converted to URL links.}

\item{url_map_by_words_list}{(optional) Similar to url_map_list, except that instead of mapping the full value of a text
field, the function looks for occurrences of key values within the text using \code{gsub()} to substitute a URL link tag.
This allows fields containing multiple IDs to be converted to a group of URL links.}

\item{min_decimal}{(optional) The minimal value for decimal format. Below this, scientific notation is used (default 0.0005).}

\item{quiet}{(optional) If \code{FALSE}, this tells the function to emit warnings when an identifier term has no matching
URL. By default, this value is \code{TRUE}, suppressing this behavior.}

\item{table_row_colors}{(optional) This argument specifies the row background colors used to contrast different subnets.
(default: c("1"="#EEF","2"="#FFD"), pale blue and pale yellow)}

\item{...}{Additional arguments passed to \code{DT::datatable}.}
}
\value{
An attractive HTML table widget, optionally with unique IDs represented as links.
}
\description{
Takes a data.frame and outputs an attractively formatted HTML table widget for reports via the
using the DT and data.table package. Optionally, the user can specify, via the \code{n} parameter, the number
of rows to display in the HTML table. Optionally, IDs in specific columns can be mapped to URLs as links.
}
\examples{

# The sample data object Bai_CiKrt_DN.cerno contains MSigDB
# systematic names as gene set identifiers in its ID column
# that we can map to URLs on MSigDB's website using the
# 'systematicName' URL parameter:
msig_url <- "http://www.gsea-msigdb.org/gsea/msigdb/geneset_page.jsp"
id2url <- with( Bai_CiKrt_DN.cerno,
                structure(paste0( msig_url, "?systematicName=", ID),
                          names = ID
                         )
              )

# NOTE: In GSEA data sets against MSigDB,
# MSigDB STANDARD_NAMES (e.g. "GO_RESPONSE_TO_GLUCAGON")
# are often present in the pathways data instead of
# systematic name identifiers. They can be linked to URLs
# using the 'geneSetName' parameter, as follows:
#  sn2url <-
#   with( Bai_CiKrt_DN.gsea,
#       structure( paste0(msig_url, "?geneSetName=", STANDARD_NAME),
#                  names = STANDARD_NAME
#                )
#       )

# The named vector id2url now contains URLs for MSigDB
# gene sets, names with the gene set ID. By passing a
# list containing the id2url named as the column we
# wish to map to a URL, we can have yassifyPathways
# generate an HTML table with links for the gene set IDs.
yassifyPathways( Bai_CiKrt_DN.cerno,
                 n = 200,
                 url_map_list = list(ID = id2url) )
# Here the 'n = 200' argument tells the function to
# generate an HTML table with just the first 200 results,
# and the 'url_map_list = list(ID=id2url)' tells the
# function to link the ID column of Bai_CiKrt_DN.cerno
# to the mapped URLs in the 'id2url' vector. In this case
# the entire ID field is mapped, but if we want to map
# in a word-based fashion, for example when a column
# may contain multiple IDs per row (eg "M40804, M40775" ),
# then the 'url_map_by_words_list = list(ID = id2url)'
# argument works:
yassifyPathways( Bai_CiKrt_DN.cerno,
                 n = 200,
                 url_map_by_words_list = list(ID = id2url) )
# The url_map_list_by_words argument will work in mos
# cases where url_map_list does, so may be fine to use
# generally, but it is less efficient and my sometimes be
# slower.

}
