## ----check_packages, echo=FALSE, messages=FALSE, warning=FALSE-----------
required <- c("ggplot2", "tidyr", "lubridate")

if (!all(unlist(lapply(required, function(pkg) requireNamespace(pkg, quietly = TRUE)))))
knitr::opts_chunk$set(eval = FALSE, collapse = TRUE, comment = "#>", fig.width = 7, fig.height = 7, fig.align = "center")

## ---- eval=TRUE----------------------------------------------------------
library(GSODR)
library(dplyr)
load(system.file("extdata", "country_list.rda", package = "GSODR"))
load(system.file("extdata", "isd_history.rda", package = "GSODR"))

station_locations <- left_join(isd_history, country_list,
                               by = c("CTRY" = "FIPS"))

# create data.frame for Australia only
Oz <- subset(station_locations, COUNTRY_NAME == "AUSTRALIA")

Oz

subset(Oz, grepl("TOOWOOMBA", STN_NAME))

## ---- eval=TRUE----------------------------------------------------------
tbar <- get_GSOD(years = 2010, station = "955510-99999")

tbar

## ---- eval=FALSE---------------------------------------------------------
#  tbar_stations <- nearest_stations(LAT = -27.5598,
#                                    LON = 151.9507,
#                                    distance = 50)
#  
#  tbar <- get_GSOD(years = 2010, station = tbar_stations)

## ---- eval=FALSE---------------------------------------------------------
#  remove <- c("949999-00170", "949999-00183")
#  
#  tbar_stations <- tbar_stations[!tbar_stations %in% remove]
#  
#  tbar <- get_GSOD(years = 2010,
#                   station = tbar_stations,
#                   dsn = "~/")

## ---- eval=TRUE, fig.width = 7, fig.height = 7, fig.align = "center"-----
library(ggplot2)
library(lubridate)
library(tidyr)

# Create a dataframe of just the date and temperature values that we want to
# plot
tbar_temps <- tbar[, c("YEARMODA", "TEMP", "MAX", "MIN")]

# Gather the data from wide to long
tbar_temps <- gather(tbar_temps, Measurement, gather_cols = TEMP:MIN)

ggplot(data = tbar_temps, aes(x = ymd(YEARMODA), y = value,
                              colour = Measurement)) +
  geom_line() +
  scale_color_brewer(type = "qual", na.value = "black") +
  scale_y_continuous(name = "Temperature") +
  scale_x_date(name = "Date") +
  theme_bw()

## ---- eval=FALSE---------------------------------------------------------
#  future::plan("multisession")
#  global <- get_GSOD(years = 2010:2015)

## ----spatial_convert, eval = FALSE---------------------------------------
#  # get GSOD data
#  library(sp)
#  GSOD <- get_GSOD(years = 2015, country = "Australia")
#  
#  # convert to SpatialPointsDataFrame
#  coordinates(GSOD_sp) <- ~ LON + LAT
#  proj4string(GSOD_sp) <- CRS("+proj=longlat +datum=WGS84")
#  
#  str(GSOD_sp)

## ----sp_str--------------------------------------------------------------
#> Formal class 'SpatialPointsDataFrame' [package "sp"] with 5 slots
#>   ..@ data       :Classes ‘tbl_df’, ‘tbl’ and 'data.frame':	186977 obs. of  46 variables:
#>   .. ..$ USAF            : chr [1:186977] "941000" "941000" "941000" "941000" ...
#>   .. ..$ WBAN            : chr [1:186977] "99999" "99999" "99999" "99999" ...
#>   .. ..$ STNID           : chr [1:186977] "941000-99999" "941000-99999" "941000-99999" "941000-99999" ...
#>   .. ..$ STN_NAME        : chr [1:186977] "KALUMBURU" "KALUMBURU" "KALUMBURU" "KALUMBURU" ...
#>   .. ..$ CTRY            : chr [1:186977] "AS" "AS" "AS" "AS" ...
#>   .. ..$ STATE           : chr [1:186977] NA NA NA NA ...
#>   .. ..$ CALL            : chr [1:186977] NA NA NA NA ...
#>   .. ..$ ELEV_M          : num [1:186977] 24 24 24 24 24 24 24 24 24 24 ...
#>   .. ..$ ELEV_M_SRTM_90m : num [1:186977] 17 17 17 17 17 17 17 17 17 17 ...
#>   .. ..$ BEGIN           : num [1:186977] 2e+07 2e+07 2e+07 2e+07 2e+07 ...
#>   .. ..$ END             : num [1:186977] 20171212 20171212 20171212 20171212 20171212 ...
#>   .. ..$ YEARMODA        : Date[1:186977], format: "2015-01-01" "2015-01-02" "2015-01-03" ...
#>   .. ..$ YEAR            : chr [1:186977] "2015" "2015" "2015" "2015" ...
#>   .. ..$ MONTH           : chr [1:186977] "01" "01" "01" "01" ...
#>   .. ..$ DAY             : chr [1:186977] "01" "02" "03" "04" ...
#>   .. ..$ YDAY            : num [1:186977] 1 2 3 4 5 6 7 8 9 10 ...
#>   .. ..$ TEMP            : num [1:186977] 26.9 27.2 26.3 27.3 27.3 26.7 28.1 28.7 27.6 27.8 ...
#>   .. ..$ TEMP_CNT        : int [1:186977] 16 16 16 16 16 16 16 16 16 16 ...
#>   .. ..$ DEWP            : num [1:186977] 23.2 23.3 23.8 24.1 24.3 24 23.6 23.3 21.9 22.3 ...
#>   .. ..$ DEWP_CNT        : int [1:186977] 16 16 16 16 16 16 16 16 16 16 ...
#>   .. ..$ SLP             : num [1:186977] 1004 1003 1003 1002 1001 ...
#>   .. ..$ SLP_CNT         : int [1:186977] 16 16 16 16 16 16 16 16 16 16 ...
#>   .. ..$ STP             : num [1:186977] 1002 1000 NA 999 998 ...
#>   .. ..$ STP_CNT         : int [1:186977] 16 16 16 16 16 16 16 16 16 16 ...
#>   .. ..$ VISIB           : num [1:186977] NA NA NA NA NA NA NA NA NA NA ...
#>   .. ..$ VISIB_CNT       : int [1:186977] 0 0 0 0 0 0 0 0 0 0 ...
#>   .. ..$ WDSP            : num [1:186977] 1.7 2.2 1.7 2 2.6 3.4 4.5 5.9 4.4 2.4 ...
#>   .. ..$ WDSP_CNT        : int [1:186977] 16 16 16 16 16 16 16 16 16 16 ...
#>   .. ..$ MXSPD           : num [1:186977] 4.1 4.1 4.1 4.1 5.7 5.7 6.7 9.3 7.7 4.6 ...
#>   .. ..$ GUST            : num [1:186977] NA NA NA NA NA NA NA NA NA NA ...
#>   .. ..$ MAX             : num [1:186977] 31.5 31.3 29.2 32.1 31.4 28.6 30.2 31 32.7 32.9 ...
#>   .. ..$ MAX_FLAG        : chr [1:186977] NA NA NA NA ...
#>   .. ..$ MIN             : num [1:186977] 25 24.9 24.4 24.3 24.6 25.1 24.5 26.3 22.8 22.6 ...
#>   .. ..$ MIN_FLAG        : chr [1:186977] NA "*" "*" NA ...
#>   .. ..$ PRCP            : num [1:186977] 16.5 12.4 5.1 20.3 41.1 20.1 82.3 2.3 6.1 27.4 ...
#>   .. ..$ PRCP_FLAG       : chr [1:186977] "G" "G" "G" "G" ...
#>   .. ..$ SNDP            : num [1:186977] NA NA NA NA NA NA NA NA NA NA ...
#>   .. ..$ I_FOG           : int [1:186977] 0 0 0 0 0 0 0 0 0 0 ...
#>   .. ..$ I_RAIN_DRIZZLE  : int [1:186977] 1 1 1 1 1 1 1 1 1 0 ...
#>   .. ..$ I_SNOW_ICE      : int [1:186977] 0 0 0 0 0 0 0 0 0 0 ...
#>   .. ..$ I_HAIL          : int [1:186977] 0 0 0 0 0 0 0 0 0 0 ...
#>   .. ..$ I_THUNDER       : int [1:186977] 0 0 0 0 0 0 0 0 0 0 ...
#>   .. ..$ I_TORNADO_FUNNEL: int [1:186977] 0 0 0 0 0 0 0 0 0 0 ...
#>   .. ..$ EA              : num [1:186977] 2.8 2.9 2.9 3 3 3 2.9 2.9 2.6 2.7 ...
#>   .. ..$ ES              : num [1:186977] 3.5 3.6 3.4 3.6 3.6 3.5 3.8 3.9 3.7 3.7 ...
#>   .. ..$ RH              : num [1:186977] 80 80.6 85.3 83.3 83.3 85.7 76.3 74.4 70.3 73 ...
#>   ..@ coords.nrs : int [1:2] 9 8
#>   ..@ coords     : num [1:186977, 1:2] 127 127 127 127 127 ...
#>   .. ..- attr(*, "dimnames")=List of 2
#>   .. .. ..$ : chr [1:186977] "1" "2" "3" "4" ...
#>   .. .. ..$ : chr [1:2] "LON" "LAT"
#>   ..@ bbox       : num [1:2, 1:2] 73.7 -54.5 159.1 -10.1
#>   .. ..- attr(*, "dimnames")=List of 2
#>   .. .. ..$ : chr [1:2] "LON" "LAT"
#>   .. .. ..$ : chr [1:2] "min" "max"
#>   ..@ proj4string:Formal class 'CRS' [package "sp"] with 1 slot
#>   .. .. ..@ projargs: chr "+proj=longlat +datum=WGS84 +ellps=WGS84 +towgs84=0,0,0"

## ----sp_save_gpkg, eval=FALSE--------------------------------------------
#  library(rgdal)
#  
#    writeOGR(
#      GSOD_sp,
#      dsn = path.expand("~/"),
#      layer = "GSOD",
#      driver = "GPKG"
#    )

## ----sp_save_shp, eval=FALSE---------------------------------------------
#    writeOGR(
#      GSOD_sp,
#      dsn = path.expand("~/"),
#      layer = "GSOD",
#      driver = "ESRI Shapefile"
#    )

## ----convert_sf, eval=FALSE----------------------------------------------
#  library(sf)
#  GSOD_SF <- st_as_sf(x = GSOD,
#                          coords = c("LON", "LAT"),
#                          crs = "+proj=longlat +datum=WGS84")
#  
#  str(GSOD_SF)

## ----sf_str, eval=FALSE--------------------------------------------------
#  #> Classes ‘sf’ and 'data.frame':	186977 obs. of  47 variables:
#  #>  $ USAF            : chr  "941000" "941000" "941000" "941000" ...
#  #>  $ WBAN            : chr  "99999" "99999" "99999" "99999" ...
#  #>  $ STNID           : chr  "941000-99999" "941000-99999" "941000-99999" "941000-99999" ...
#  #>  $ STN_NAME        : chr  "KALUMBURU" "KALUMBURU" "KALUMBURU" "KALUMBURU" ...
#  #>  $ CTRY            : chr  "AS" "AS" "AS" "AS" ...
#  #>  $ STATE           : chr  NA NA NA NA ...
#  #>  $ CALL            : chr  NA NA NA NA ...
#  #>  $ ELEV_M          : num  24 24 24 24 24 24 24 24 24 24 ...
#  #>  $ ELEV_M_SRTM_90m : num  17 17 17 17 17 17 17 17 17 17 ...
#  #>  $ BEGIN           : num  2e+07 2e+07 2e+07 2e+07 2e+07 ...
#  #>  $ END             : num  20171212 20171212 20171212 20171212 20171212 ...
#  #>  $ YEARMODA        : Date, format: "2015-01-01" "2015-01-02" ...
#  #>  $ YEAR            : chr  "2015" "2015" "2015" "2015" ...
#  #>  $ MONTH           : chr  "01" "01" "01" "01" ...
#  #>  $ DAY             : chr  "01" "02" "03" "04" ...
#  #>  $ YDAY            : num  1 2 3 4 5 6 7 8 9 10 ...
#  #>  $ TEMP            : num  26.9 27.2 26.3 27.3 27.3 26.7 28.1 28.7 27.6 27.8 ...
#  #>  $ TEMP_CNT        : int  16 16 16 16 16 16 16 16 16 16 ...
#  #>  $ DEWP            : num  23.2 23.3 23.8 24.1 24.3 24 23.6 23.3 21.9 22.3 ...
#  #>  $ DEWP_CNT        : int  16 16 16 16 16 16 16 16 16 16 ...
#  #>  $ SLP             : num  1004 1003 1003 1002 1001 ...
#  #>  $ SLP_CNT         : int  16 16 16 16 16 16 16 16 16 16 ...
#  #>  $ STP             : num  1002 1000 NA 999 998 ...
#  #>  $ STP_CNT         : int  16 16 16 16 16 16 16 16 16 16 ...
#  #>  $ VISIB           : num  NA NA NA NA NA NA NA NA NA NA ...
#  #>  $ VISIB_CNT       : int  0 0 0 0 0 0 0 0 0 0 ...
#  #>  $ WDSP            : num  1.7 2.2 1.7 2 2.6 3.4 4.5 5.9 4.4 2.4 ...
#  #>  $ WDSP_CNT        : int  16 16 16 16 16 16 16 16 16 16 ...
#  #>  $ MXSPD           : num  4.1 4.1 4.1 4.1 5.7 5.7 6.7 9.3 7.7 4.6 ...
#  #>  $ GUST            : num  NA NA NA NA NA NA NA NA NA NA ...
#  #>  $ MAX             : num  31.5 31.3 29.2 32.1 31.4 28.6 30.2 31 32.7 32.9 ...
#  #>  $ MAX_FLAG        : chr  NA NA NA NA ...
#  #>  $ MIN             : num  25 24.9 24.4 24.3 24.6 25.1 24.5 26.3 22.8 22.6 ...
#  #>  $ MIN_FLAG        : chr  NA "*" "*" NA ...
#  #>  $ PRCP            : num  16.5 12.4 5.1 20.3 41.1 20.1 82.3 2.3 6.1 27.4 ...
#  #>  $ PRCP_FLAG       : chr  "G" "G" "G" "G" ...
#  #>  $ SNDP            : num  NA NA NA NA NA NA NA NA NA NA ...
#  #>  $ I_FOG           : int  0 0 0 0 0 0 0 0 0 0 ...
#  #>  $ I_RAIN_DRIZZLE  : int  1 1 1 1 1 1 1 1 1 0 ...
#  #>  $ I_SNOW_ICE      : int  0 0 0 0 0 0 0 0 0 0 ...
#  #>  $ I_HAIL          : int  0 0 0 0 0 0 0 0 0 0 ...
#  #>  $ I_THUNDER       : int  0 0 0 0 0 0 0 0 0 0 ...
#  #>  $ I_TORNADO_FUNNEL: int  0 0 0 0 0 0 0 0 0 0 ...
#  #>  $ EA              : num  2.8 2.9 2.9 3 3 3 2.9 2.9 2.6 2.7 ...
#  #>  $ ES              : num  3.5 3.6 3.4 3.6 3.6 3.5 3.8 3.9 3.7 3.7 ...
#  #>  $ RH              : num  80 80.6 85.3 83.3 83.3 85.7 76.3 74.4 70.3 73 ...
#  #>  $ geometry        :sfc_POINT of length 186977; first list element: Classes 'XY', 'POINT', 'sfg'  num [1:2] 126.6 -14.3
#  #>  - attr(*, "sf_column")= chr "geometry"
#  #>  - attr(*, "agr")= Factor w/ 3 levels "constant","aggregate",..: NA NA NA NA NA NA NA NA NA NA ...
#  #>   ..- attr(*, "names")= chr  "USAF" "WBAN" "STNID" "STN_NAME" ...

## ----sf_save_shp, eval=FALSE---------------------------------------------
#  write_sf(GSOD_SF, "GSOD.shp") # silently overwrites

## ----sf_save_gpkg, eval=FALSE--------------------------------------------
#  write_sf(GSOD_SF, "~/GSOD.gpkg") # silently overwrites

## ---- eval=FALSE---------------------------------------------------------
#  library(rgdal)
#  #> Loading required package: sp
#  #> rgdal: version: 1.1-10, (SVN revision 622)
#  #>  Geospatial Data Abstraction Library extensions to R successfully loaded
#  #>  Loaded GDAL runtime: GDAL 1.11.5, released 2016/07/01
#  #>  Path to GDAL shared files: /usr/local/Cellar/gdal/1.11.5_1/share/gdal
#  #>  Loaded PROJ.4 runtime: Rel. 4.9.3, 15 August 2016, [PJ_VERSION: 493]
#  #>  Path to PROJ.4 shared files: (autodetected)
#  #>  Linking to sp version: 1.2-3
#  
#  AUS_stations <- readOGR(dsn = path.expand("~/GSOD.gpkg"), layer = "GSOD")
#  #> OGR data source with driver: GPKG
#  #> Source: "/Users/asparks/AUS-2015.gpkg", layer: "GSOD"
#  #> with 186977 features
#  #> It has 46 fields
#  
#  class(AUS_stations)
#  #> [1] "SpatialPointsDataFrame"
#  #> attr(,"package")
#  #> [1] "sp"

## ---- eval=FALSE---------------------------------------------------------
#  AUS_sqlite <- tbl(src_sqlite(path.expand("~/GSOD.gpkg")), "GSOD")
#  class(AUS_sqlite)
#  #> [1] "tbl_dbi"  "tbl_sql"  "tbl_lazy" "tbl"

## ---- eval=FALSE---------------------------------------------------------
#  y <- c("~/GSOD/gsod_1960/200490-99999-1960.op.gz",
#         "~/GSOD/gsod_1961/200490-99999-1961.op.gz")
#  x <- reformat_GSOD(file_list = y)

## ---- eval=FALSE---------------------------------------------------------
#  x <- reformat_GSOD(dsn = "~/GSOD/gsod_1960")

## ---- eval=FALSE---------------------------------------------------------
#  inventory <- get_inventory()
#  
#  inventory
#  
#  subset(inventory, STNID == "955510-99999")

## ---- eval=FALSE---------------------------------------------------------
#  #install.packages("devtools")
#  devtools::install_github("adamhsparks/GSODRdata")
#  library("GSODRdata")

## ---- eval=TRUE, message = FALSE, echo = FALSE, warning=FALSE, fig.width = 7, fig.height = 5, fig.align = "center"----
if (requireNamespace("ggplot2", quietly = TRUE) &&
    requireNamespace("ggthemes", quietly = TRUE) &&
    requireNamespace("maps", quietly = TRUE) &&
    requireNamespace("mapproj", quietly = TRUE) &&
    requireNamespace("gridExtra", quietly = TRUE) &&
    requireNamespace("grid", quietly = TRUE)) {
  library(ggplot2)
  library(mapproj)
  library(ggthemes)
  library(maps)
  library(grid)
  library(gridExtra)
  library(GSODR)
  load(system.file("extdata", "isd_history.rda", package = "GSODR"))
  world_map <- map_data("world")

  GSOD_stations <- ggplot(isd_history, aes(x = LON, y = LAT)) +
    geom_polygon(data = world_map, aes(x = long, y = lat, group = group),
                 color = grey(0.7),
                 fill = NA) +
    geom_point(color = "red",
               size = 0.05) +
    coord_map(xlim = c(-180, 180)) +
    theme_map() +
    labs(title = "GSOD Station Locations",
         caption = "Data: US NCEI GSOD and CIA World DataBank II")

  # Using the gridExtra and grid packages add a neatline to the map
  grid.arrange(GSOD_stations, ncol = 1)
  grid.rect(width = 0.98,
            height = 0.98,
            gp = grid::gpar(lwd = 0.25,
                            col = "black",
                            fill = NA))
}

