% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_selection.R
\name{gene_selection_surv}
\alias{gene_selection_surv}
\title{Gene selection based on variability and the relationship
to survival.}
\usage{
gene_selection_surv(
  case_disease_component,
  cox_all_matrix,
  gen_select_type,
  num_gen_select
)
}
\arguments{
\item{case_disease_component}{Disease component matrix (output of the function
\code{generate_disease_component}) having selected only the columns
belonging to disease samples. The names of the rows must be the names of the genes.}

\item{cox_all_matrix}{Output from the \code{cox_all_genes} function. Data.frame with
information on the relationship between genes and survival.}

\item{gen_select_type}{Option. Select the "Abs" option, which means that the
genes with the highest absolute value are chosen, or the
"Top_Bot" option, which means that half of the selected
genes are those with the highest value (positive value, i.e.
worst survival prognosis) and the other half are those with the
lowest value (negative value, i.e. best prognosis).}

\item{num_gen_select}{Number of genes to be selected (those with the highest
product value).}
}
\value{
Character vector with the names of the selected genes.
}
\description{
It selects genes for mapper based on the product of standard deviation
of the rows (genes) in the disease component matrix
plus one times the Z score obtained by fitting a cox proportional
hazard model to the level of each gene. For further information see
"Topology based data analysis identifies a subgroup of breast cancers
with a unique mutational profile and excellent survival"
}
