% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWex_lib.r
\name{GwexObs}
\alias{GwexObs}
\title{Constructor}
\usage{
GwexObs(variable, date, obs)
}
\arguments{
\item{variable}{'Prec' or 'Temp'}

\item{date}{vector of class 'Date'}

\item{obs}{matrix nTime x nStations of observations}
}
\value{
An object of class [\code{\linkS4class{GwexObs}}]
}
\description{
Constructor of class [\code{\linkS4class{GwexObs}}]
}
\examples{
# Format dates corresponding to daily observations of precipitation and temperature
vecDates = seq(from=as.Date("01/01/2005",format="\%d/\%m/\%Y"),
to=as.Date("31/12/2014",format="\%d/\%m/\%Y"),by='day')

# build GwexObs object with precipitation data
myObsPrec = GwexObs(variable='Prec',date=vecDates,obs=dailyPrecipGWEX)

# print GwexObs object
myObsPrec 

# build GwexObs object with temperature data
myObsTemp = GwexObs(variable='Temp',date=vecDates,obs=dailyTemperGWEX)

# print GwexObs object
myObsTemp
}
