% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gw.r
\name{gw}
\alias{gw}
\alias{gw.fit}
\title{Fitting GWRM Models}
\usage{
gw(formula, data, weights, k = NULL, subset, na.action, kstart = 1,
  rostart = 2, betastart = NULL, offset, control = list(...),
  method = NULL, hessian = TRUE, model = TRUE, x = FALSE, y = TRUE,
  ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from \code{environment(formula)}.}

\item{weights}{an optional vector of 'prior weights' to be used in the fitting process. Should be \code{NULL} or a numeric vector.}

\item{k}{optional value for the \code{k} parameter. If \code{NULL}, it is estimated.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain \code{NA} values. See \code{\link{glm}}.}

\item{kstart}{starting value for the \code{k} parameter.}

\item{rostart}{starting value for the \code{ro} parameter.}

\item{betastart}{starting values for the vector of means.}

\item{offset}{this can be used to specify an a priori known component to be included in the linear predictor during fitting. This should be \code{NULL} or a numeric vector of length equal to the number of cases. One or more offset terms can be included in the formula instead or as well, and if more than one is specified their sum is used. See \code{\link{model.offset}}.}

\item{control}{a list of parameters for controlling the fitting process.}

\item{method}{the method to be used in fitting the model. The default method initially uses non-linear minimization (\code{nlm}) and Nelder-Mead optimization (\code{optim}) to fit a model which is then re-fitted by \code{"L-BFGS-B"} (\code{optim}). In this way, SE estimates for all the model parameters are provided. \code{"nlm"} and \code{"Nelder-Mead"} are also possible values, but they do not provide SE estimates for \code{k} and \code{ro}.}

\item{hessian}{if \code{TRUE}, the hessian of \code{f} at the minimum is returned.}

\item{model}{a logical value indicating whether model frame should be included as a component of the returned value.}

\item{x,y}{For \code{gw}: logical values indicating whether the response vector and model matrix used in the fitting process should be returned as components of the returned value.

For \code{gw.fit}: \code{x} is a design matrix of dimension \code{n * p}, and \code{y} is a vector of observations of length \code{n}.}

\item{...}{further arguments.}
}
\value{
\code{gw} returns an object of class \code{"gw"}. The function \code{summary} can be used to obtain or print a summary of the results. An object of class \code{"gw"} is a list containing the following components:
\itemize{
\item \code{Y} {if requested (the default), the \code{y} vector used.}
\item \code{W} {the weights supplied, a vector of \code{1}s if none were.}
\item \code{covars} {names of the covariates in the model.}
\item \code{nobs} {number of observations.}
\item \code{covoffset} {a logical value specifying if an offset is present.}
\item \code{loglik} {the maximized log-likelihood.}
\item \code{aic} {a version of Akaike's \emph{An Information Criterion}, minus twice the maximized log-likelihood plus twice the number of parameters.}
\item \code{bic} {Bayesian Information Criterion, minus twice the maximized log-likelihood plus the number of parameters multiplied by the logarithm of the number of observations.}
\item \code{df.residual} {the residual degrees of freedom.}
\item \code{residuals} {the residuals in the final iteration of the fit.}
\item \code{coefficients} {a named vector of coefficients.}
\item \code{betaIIpars} {parameters estimates of the BetaII distribution.}
\item \code{betascoefs} {a vector of coefficients.}
\item \code{fitted.values} {the fitted mean values, obtained by transforming the linear predictors by the inverse of the link function.}
\item \code{hessian} {a symmetric matrix giving an estimate of the Hessian at the solution found in the optimization of the log-likelihood function.}
\item \code{cov} {an estimate of the covariance matrix of the model coefficients.}
\item \code{se} {a vector of the standard errors estimates of the estimated coefficients.}
\item \code{corr} {an estimate of the correlation matrix of the model coefficients.}
\item \code{code} {a code that indicates successful convergence of the fitter function used (see \code{nlm} and \code{optim} helps).}
\item \code{converged} {logical value that indicates if the optimization algorithms succesfull.}
\item \code{method} {the name of the fitter function used.}
\item \code{k} {if requested, the \code{k} value used.}
\item \code{kBool} {a logical value specifying whether there is a \code{k} value or it is estimated.}
\item \code{call} {the matched call.}
\item \code{formula} {the formula supplied.}
\item \code{terms} {the \code{terms} object used.}
\item \code{data} {the \code{data} argument.}
\item \code{offset} {the offset vector used.}
\item \code{control} {the value of the \code{control} argument used.}
\item \code{method} {the name of the fitter function used.}
\item \code{contrasts} {(where relevant) the contrasts used.}
\item \code{xlevels} {(where relevant) a record of the levels of the factors used in fitting.}
}
}
\description{
\code{gw} is used to fit Generalized Waring Regression Models (GWRM), specified by giving a symbolic description of the linear predictor.
}
\examples{
data(goals)
gw(goals ~ position + offset(log(played)), data = goals)
}

