% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotEffects.R
\name{PlotJointEffects}
\alias{PlotJointEffects}
\title{Plot the estimated joint effects.}
\usage{
PlotJointEffects(
  joint_effect,
  anova_percent,
  x_units = NULL,
  y_name = "y",
  y_units = "",
  se_plot = TRUE,
  y_values = NULL,
  se_values = NULL
)
}
\arguments{
\item{joint_effect}{A data frame from \code{\link{Visualize}}
with plotting coordinates for the estimated joint effects.}

\item{anova_percent}{A data frame from \code{\link{Visualize} of ANOVA percentages}.}

\item{x_units}{An optional vector of character strings containing the units
of the input variables (for labels).}

\item{y_name}{An optional character string containing the output variable name
(for labels).}

\item{y_units}{An optional character string containing the units
of the output variable (for labels).}

\item{se_plot}{An optional boolean indicating whether to make
standard-error contour plots.}

\item{y_values}{An optional vector of contour values for the estimated
joint effects.}

\item{se_values}{An optional vector of contour values for the standard
errors.}
}
\value{
No return value, generates plots.
}
\description{
Plot the estimated joint effects.
}
\details{
Plots are sent to the active device.
}
\examples{
\dontshow{
x <- borehole$x
y <- borehole$y
theta <- c(
  5.767699e+01, 0.000000e+00, 0.000000e+00, 1.433571e-06,
  0.000000e+00, 2.366557e-06, 1.695619e-07, 2.454376e-09
)
alpha <- c(
  1.110223e-16, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 2.494862e-03, 0.000000e+00
)
cor_par <- data.frame(Theta = theta, Alpha = alpha)
rownames(cor_par) <- colnames(borehole$x)
sp_var <- 38783.7
borehole_fit <- GaSPModel(
  x = borehole$x, y = borehole$y,
  reg_model = ~1, cor_family = "PowerExponential",
  cor_par = cor_par, random_error = FALSE,
  sp_var = sp_var
)
borehole_x_names <- colnames(borehole$x)
borehole_min <- c(0.05, 100.00, 63070.00, 990.00, 63.10, 700.00, 1120.00, 9855.00)
borehole_max <- c(0.15, 50000.00, 115600.00, 1110.00, 116.00, 820.00, 1680.00, 12045.00)
borehole_x_desc <- DescribeX(borehole_x_names, borehole_min, borehole_max)
borehole_vis <- Visualize(borehole_fit, borehole_x_desc)
}
PlotJointEffects(borehole_vis$joint_effect, borehole_vis$anova_percent)
}
